/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.xforceplus.ultraman.oqsengine.meta.common.dto.WatchElement;
import com.xforceplus.ultraman.oqsengine.meta.common.monitor.dto.MetricsLog;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncRspProto;
import com.xforceplus.ultraman.oqsengine.meta.handler.IRequestHandler;
import com.xforceplus.ultraman.oqsengine.meta.provider.outter.SyncExecutor;
import com.xforceplus.ultraman.oqsengine.metadata.MetaManager;
import com.xforceplus.ultraman.oqsengine.metadata.cache.CacheExecutor;
import com.xforceplus.ultraman.oqsengine.metadata.cache.DefaultCacheExecutor;
import com.xforceplus.ultraman.oqsengine.metadata.dto.HealthCheckEntityClass;
import com.xforceplus.ultraman.oqsengine.metadata.dto.log.UpGradeLog;
import com.xforceplus.ultraman.oqsengine.metadata.dto.metrics.AppSimpleInfo;
import com.xforceplus.ultraman.oqsengine.metadata.dto.metrics.MetaMetrics;
import com.xforceplus.ultraman.oqsengine.metadata.dto.model.AbstractMetaModel;
import com.xforceplus.ultraman.oqsengine.metadata.dto.model.MetaModel;
import com.xforceplus.ultraman.oqsengine.metadata.dto.model.OfflineModel;
import com.xforceplus.ultraman.oqsengine.metadata.dto.storage.EntityClassStorage;
import com.xforceplus.ultraman.oqsengine.metadata.dto.storage.RelationStorage;
import com.xforceplus.ultraman.oqsengine.metadata.utils.CacheUtils;
import com.xforceplus.ultraman.oqsengine.metadata.utils.offline.FileReaderUtils;
import com.xforceplus.ultraman.oqsengine.metadata.utils.offline.OffLineMetaHelper;
import com.xforceplus.ultraman.oqsengine.metadata.utils.storage.CacheToStorageGenerator;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.EntityClassType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relationship;
import io.micrometer.core.annotation.Timed;
import io.vavr.Tuple2;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageMetaManager
implements MetaManager {
    final Logger logger = LoggerFactory.getLogger(StorageMetaManager.class);
    @Resource
    private CacheExecutor cacheExecutor;
    @Resource
    private IRequestHandler requestHandler;
    @Resource(name="grpcSyncExecutor")
    private SyncExecutor syncExecutor;
    private AbstractMetaModel metaModel;
    private static int NEED_MAX_WAIT_LOOPS = 60;

    public StorageMetaManager(AbstractMetaModel metaModel) {
        this.metaModel = metaModel;
    }

    @PostConstruct
    public void init() {
        if (this.metaModel.getModel().equals((Object)MetaModel.OFFLINE)) {
            String path = ((OfflineModel)this.metaModel).getPath();
            this.logger.info("start load from local path : {}", (Object)path);
            this.offLineInit(path);
            this.logger.info("success load from local path : {}", (Object)path);
        }
    }

    @Override
    public Collection<IEntityClass> appLoad(String appId) {
        try {
            ArrayList<IEntityClass> collection = new ArrayList<IEntityClass>();
            int currentVersion = this.cacheExecutor.version(appId);
            if (currentVersion == -1) {
                return collection;
            }
            Collection<Long> entityClassIds = this.cacheExecutor.appEntityIdList(appId, currentVersion);
            if (entityClassIds.isEmpty()) {
                return collection;
            }
            entityClassIds.forEach(entityClassId -> collection.addAll(this.doWithProfilesLoad((long)entityClassId, currentVersion)));
            return collection;
        }
        catch (Exception e) {
            this.logger.warn("load meta by appId error, appId {}, message : {}", (Object)appId, (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    @Timed(value="oqs.process.delay.latency", extraTags={"initiator", "meta", "action", "load"})
    public Optional<IEntityClass> load(long entityClassId, String profile) {
        return this.load(entityClassId, -1, profile);
    }

    @Override
    public Optional<IEntityClass> load(long entityClassId, int version, String profile) {
        if (entityClassId == HealthCheckEntityClass.getInstance().id()) {
            return Optional.of(HealthCheckEntityClass.getInstance());
        }
        return (Optional)this.entityClassLoadWithVersion(entityClassId, version, profile)._2();
    }

    @Override
    public Collection<IEntityClass> withProfilesLoad(long entityClassId) {
        return this.doWithProfilesLoad(entityClassId, -1);
    }

    @Override
    public int need(String appId, String env) {
        return this.need(appId, env, false);
    }

    @Override
    public int need(String appId, String env, boolean reset) {
        this.cacheExecutor.appEnvSet(appId, env);
        String cacheEnv = this.cacheExecutor.appEnvGet(appId);
        if (!cacheEnv.equals(env)) {
            this.logger.warn("appId [{}], param env [{}] not equals to cache's env [{}], will use cache to register.", new Object[]{appId, env, cacheEnv});
            throw new RuntimeException("appId has been init with another Id, need failed...");
        }
        int version = -1;
        if (!reset) {
            version = this.cacheExecutor.version(appId);
        }
        if (this.metaModel.getModel().equals((Object)MetaModel.CLIENT_SYNC)) {
            WatchElement watchElement = new WatchElement(appId, env, version, WatchElement.ElementStatus.Register);
            if (reset) {
                this.requestHandler.reset(watchElement);
            } else {
                this.requestHandler.register(watchElement);
            }
            if (reset || version <= -1) {
                version = this.waitForMetaSync(appId);
            }
        } else if (version <= -1) {
            throw new RuntimeException(String.format("local cache has not init this version of appId [%s].", appId));
        }
        return version;
    }

    @Override
    public void invalidateLocal() {
        this.cacheExecutor.invalidateLocal();
    }

    @Override
    public boolean metaImport(String appId, String env, int version, String content) {
        this.cacheExecutor.appEnvSet(appId, env);
        if (!this.cacheExecutor.appEnvGet(appId).equals(env)) {
            throw new RuntimeException("appId has been init with another Id, need failed...");
        }
        int currentVersion = this.cacheExecutor.version(appId);
        if (version > currentVersion) {
            EntityClassSyncRspProto entityClassSyncRspProto;
            this.logger.info("execute data import, appId {}, currentVersion {}, update version {}", new Object[]{appId, currentVersion, version});
            try {
                entityClassSyncRspProto = OffLineMetaHelper.toEntityClassSyncRspProto(content);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("parse data to EntityClassSyncRspProto failed, message [%s]", e.getMessage()));
            }
            try {
                this.syncExecutor.sync(appId, env, version, entityClassSyncRspProto);
            }
            catch (Exception e) {
                throw new RuntimeException("sync data to EntityClassSyncRspProto failed");
            }
            return true;
        }
        String message = String.format("appId [%s], current version [%d] greater than update version [%d], ignore...", appId, currentVersion, version);
        this.logger.warn(message);
        return false;
    }

    @Override
    public Optional<MetaMetrics> showMeta(String appId) throws Exception {
        try {
            int currentVersion = this.cacheExecutor.version(appId);
            if (currentVersion == -1) {
                return Optional.empty();
            }
            Collection<EntityClassStorage> result = CacheToStorageGenerator.toEntityClassStorages(DefaultCacheExecutor.OBJECT_MAPPER, this.cacheExecutor.multiRemoteRead(this.cacheExecutor.appEntityIdList(appId, currentVersion), currentVersion)).values();
            return Optional.of(new MetaMetrics(currentVersion, this.cacheExecutor.appEnvGet(appId), appId, result));
        }
        catch (Exception e) {
            this.logger.warn("show meta error, appId {}, message : {}", (Object)appId, (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public Collection<MetricsLog> metaLogs(MetricsLog.ShowType showType) {
        return this.requestHandler.metricsRecorder().showLogs(showType);
    }

    @Override
    public int reset(String appId, String env) {
        String cacheEnv = this.cacheExecutor.appEnvGet(appId);
        if (null == cacheEnv || cacheEnv.isEmpty()) {
            return this.need(appId, env);
        }
        int version = this.cacheExecutor.version(appId);
        if (!cacheEnv.equals(env)) {
            if (version > -1) {
                this.cacheExecutor.clean(appId, version, true);
            }
            this.cacheExecutor.appEnvRemove(appId);
            version = this.need(appId, env, true);
        }
        return version;
    }

    @Override
    public boolean remove(String appId) {
        int version = this.cacheExecutor.version(appId);
        if (version > -1) {
            this.cacheExecutor.clean(appId, version, true);
        }
        this.cacheExecutor.appEnvRemove(appId);
        return true;
    }

    @Override
    public Collection<AppSimpleInfo> showApplications() {
        return this.cacheExecutor.showAppInfo();
    }

    private void offLineInit(String path) {
        if (OffLineMetaHelper.isValidPath(path)) {
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            List<String> files = FileReaderUtils.getFileNamesInOneDir(path);
            for (String file : files) {
                try {
                    String[] splitter = OffLineMetaHelper.splitMetaFromFileName(file);
                    String appId = splitter[0];
                    int version = Integer.parseInt(splitter[1]);
                    String fullPath = path + file;
                    String v = OffLineMetaHelper.initDataFromFilePath(appId, splitter[2], version, fullPath);
                    if (this.metaImport(splitter[0], splitter[2], version, v)) {
                        this.logger.info("init meta from local path success, path : {}, appId : {}, version : {}", new Object[]{fullPath, appId, version});
                        continue;
                    }
                    this.logger.warn("init meta from local path failed, less than current oqs use version, path : {}", (Object)fullPath);
                }
                catch (Exception e) {
                    this.logger.warn("load from local-file failed, path : {}, message : {}", (Object)(path + file), (Object)e.getMessage());
                }
            }
            return;
        }
        this.logger.warn("load path invalid, nothing would be load from offLine-model.");
    }

    @Override
    public Collection<UpGradeLog> showUpgradeLogs(String appId, String env) throws JsonProcessingException {
        return this.cacheExecutor.showUpgradeLogs(appId, env);
    }

    private int waitForMetaSync(String appId) {
        int ver = -1;
        try {
            for (int i = 0; i < NEED_MAX_WAIT_LOOPS && (ver = this.cacheExecutor.version(appId)) <= -1; ++i) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage());
            throw e;
        }
        if (ver <= -1) {
            throw new RuntimeException(String.format("get version of appId [%s] failed, reach max wait time", appId));
        }
        return ver;
    }

    private IEntityClass classLoad(long entityClassId, String profile, int version, Map<String, String> keyValues) {
        try {
            String level;
            String type;
            EntityClass.Builder builder = EntityClass.Builder.anEntityClass();
            String id = keyValues.remove("id");
            if (null == id || id.isEmpty()) {
                throw new RuntimeException(String.format("id is null from cache, query entityClassId : %d", entityClassId));
            }
            builder.withId(Long.parseLong(id));
            String appCode = keyValues.remove("appCode");
            if (null != appCode && !appCode.isEmpty()) {
                builder.withAppCode(appCode);
            }
            builder.withType(null == (type = keyValues.remove("type")) || type.isEmpty() ? EntityClassType.DYNAMIC : EntityClassType.getInstance((int)Integer.parseInt(type)));
            String code = keyValues.remove("code");
            if (null == code || code.isEmpty()) {
                throw new RuntimeException(String.format("code is null from cache, query entityClassId : %d.", entityClassId));
            }
            builder.withCode(code);
            String name = keyValues.remove("name");
            if (null != name && !name.isEmpty()) {
                builder.withName(name);
            }
            if (null == (level = keyValues.remove("level")) || level.isEmpty()) {
                throw new RuntimeException(String.format("level is null from cache, query entityClassId : %d.", entityClassId));
            }
            builder.withLevel(Integer.parseInt(level));
            String vn = keyValues.remove("version");
            if (null == vn || vn.isEmpty()) {
                throw new RuntimeException(String.format("version is null from cache, query entityClassId : %d.", entityClassId));
            }
            builder.withVersion(Integer.parseInt(vn));
            this.withFieldsRelations(builder, profile, keyValues, this::load, this::withProfilesLoad);
            String father = keyValues.remove("father");
            if (CacheUtils.validBusinessId(father)) {
                Optional<IEntityClass> fatherEntityClassOp = this.load(Long.parseLong(father), version, profile);
                if (fatherEntityClassOp.isPresent()) {
                    builder.withFather(fatherEntityClassOp.get());
                } else {
                    throw new RuntimeException(String.format("father is null from cache, query entityClassId : %d.", entityClassId));
                }
            }
            return builder.build();
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage());
            return null;
        }
    }

    private void withFieldsRelations(EntityClass.Builder builder, String profile, Map<String, String> keyValues, BiFunction<Long, String, Optional<IEntityClass>> rightEntityClassLoader, Function<Long, Collection<IEntityClass>> rightFamilyEntityClassLoader) throws JsonProcessingException {
        ArrayList<EntityField> fields = new ArrayList<EntityField>();
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        Iterator<Map.Entry<String, String>> iterator = keyValues.entrySet().iterator();
        profile = null == profile ? "" : profile;
        boolean profileFound = false;
        while (iterator.hasNext()) {
            String key;
            Map.Entry<String, String> entry = iterator.next();
            if (entry.getKey().startsWith("fields.")) {
                fields.add(CacheUtils.resetCalculation((EntityField)DefaultCacheExecutor.OBJECT_MAPPER.readValue(entry.getValue(), EntityField.class)));
                continue;
            }
            if (entry.getKey().startsWith("profiles.fields")) {
                key = CacheUtils.parseOneKeyFromProfileEntity(entry.getKey());
                if (!key.equals(profile)) continue;
                profileFound = true;
                fields.add(CacheUtils.resetCalculation((EntityField)DefaultCacheExecutor.OBJECT_MAPPER.readValue(entry.getValue(), EntityField.class)));
                continue;
            }
            if (!entry.getKey().startsWith("profiles.relations") || profile.equals("") || !profile.equals(key = CacheUtils.parseOneKeyFromProfileRelations(entry.getKey()))) continue;
            profileFound = true;
            relationships.addAll(this.toQqsRelation((List)DefaultCacheExecutor.OBJECT_MAPPER.readValue(keyValues.get(entry.getKey()), DefaultCacheExecutor.OBJECT_MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{RelationStorage.class})), rightEntityClassLoader, rightFamilyEntityClassLoader));
        }
        builder.withProfile(profileFound ? profile : "");
        builder.withFields(fields);
        String relations = keyValues.remove("relations");
        if (null != relations && !relations.isEmpty()) {
            List relationStorageList = (List)DefaultCacheExecutor.OBJECT_MAPPER.readValue(relations, DefaultCacheExecutor.OBJECT_MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{RelationStorage.class}));
            relationships.addAll(this.toQqsRelation(relationStorageList, rightEntityClassLoader, rightFamilyEntityClassLoader));
        }
        builder.withRelations(relationships);
    }

    private List<Relationship> toQqsRelation(List<RelationStorage> relationStorageList, BiFunction<Long, String, Optional<IEntityClass>> rightEntityClassLoader, Function<Long, Collection<IEntityClass>> rightFamilyEntityClassLoader) {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        if (null != relationStorageList) {
            relationStorageList.forEach(r -> {
                Relationship.Builder builder = Relationship.Builder.anRelationship().withId(r.getId()).withCode(r.getCode()).withLeftEntityClassId(r.getLeftEntityClassId()).withLeftEntityClassCode(r.getLeftEntityClassCode()).withRelationType(Relationship.RelationType.getInstance((int)r.getRelationType())).withIdentity(r.isIdentity()).withStrong(r.isStrong()).withRightEntityClassId(r.getRightEntityClassId()).withRightEntityClassLoader(rightEntityClassLoader).withRightFamilyEntityClassLoader(rightFamilyEntityClassLoader).withEntityField((IEntityField)r.getEntityField()).withBelongToOwner(r.isBelongToOwner());
                relationships.add(builder.build());
            });
        }
        return relationships;
    }

    private Tuple2<Integer, Optional<IEntityClass>> entityClassLoadWithVersion(long entityClassId, int version, String profile) {
        Optional<IEntityClass> op;
        if (-1 == version) {
            version = this.cacheExecutor.version(entityClassId, true);
            if (-1 != version && (op = this.internalLoad(entityClassId, profile, version)).isPresent()) {
                return new Tuple2((Object)version, op);
            }
            version = this.cacheExecutor.version(entityClassId, false);
            if (-1 == version) {
                this.logger.warn("load [entityClass : {}, profile : {}] failed, version not exists", (Object)entityClassId, (Object)profile);
                return new Tuple2((Object)-1, Optional.empty());
            }
        }
        if ((op = this.internalLoad(entityClassId, profile, version)).isPresent()) {
            return new Tuple2((Object)version, op);
        }
        return new Tuple2((Object)-1, Optional.empty());
    }

    private Optional<IEntityClass> internalLoad(long entityClassId, String profile, int version) {
        Optional<IEntityClass> ecOp = this.cacheExecutor.localRead(entityClassId, version, profile);
        if (ecOp.isPresent()) {
            return ecOp;
        }
        IEntityClass entityClass = null;
        try {
            Map<String, String> keyValues = this.cacheExecutor.remoteRead(entityClassId, version);
            if (keyValues.isEmpty()) {
                throw new RuntimeException("entityClassStorage is null, may be delete.");
            }
            entityClass = this.classLoad(entityClassId, profile, version, keyValues);
            if (null != entityClass) {
                this.cacheExecutor.localStorage(entityClassId, version, profile, entityClass);
            }
        }
        catch (Exception e) {
            this.logger.warn("load entityClass failed, message : {}", (Object)e.getMessage());
        }
        return Optional.ofNullable(entityClass);
    }

    private Collection<IEntityClass> doWithProfilesLoad(long entityClassId, int version) {
        try {
            ArrayList<IEntityClass> entityClassList = new ArrayList<IEntityClass>();
            Tuple2<Integer, Optional<IEntityClass>> entityClassOp = this.entityClassLoadWithVersion(entityClassId, version, null);
            if (((Optional)entityClassOp._2()).isPresent()) {
                entityClassList.add((IEntityClass)((Optional)entityClassOp._2()).get());
                version = (Integer)entityClassOp._1();
                List<String> profiles = this.cacheExecutor.readProfileCodes(entityClassId, version);
                if (!profiles.isEmpty()) {
                    for (String profile : profiles) {
                        Optional<IEntityClass> ecOp = this.load(entityClassId, version, profile);
                        ecOp.ifPresent(entityClassList::add);
                    }
                }
            }
            return entityClassList;
        }
        catch (Exception e) {
            this.logger.warn("load entityClass [{}] error, message [{}]", (Object)entityClassId, (Object)e.getMessage());
            return new ArrayList<IEntityClass>();
        }
    }
}

