/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata.cache;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.xforceplus.ultraman.oqsengine.common.thread.PollingThreadExecutor;
import com.xforceplus.ultraman.oqsengine.common.watch.RedisLuaScriptWatchDog;
import com.xforceplus.ultraman.oqsengine.event.payload.meta.MetaChangePayLoad;
import com.xforceplus.ultraman.oqsengine.meta.common.exception.MetaSyncClientException;
import com.xforceplus.ultraman.oqsengine.metadata.cache.CacheContext;
import com.xforceplus.ultraman.oqsengine.metadata.cache.CacheExecutor;
import com.xforceplus.ultraman.oqsengine.metadata.cache.RedisLuaScript;
import com.xforceplus.ultraman.oqsengine.metadata.dto.log.UpGradeLog;
import com.xforceplus.ultraman.oqsengine.metadata.dto.metrics.AppSimpleInfo;
import com.xforceplus.ultraman.oqsengine.metadata.dto.storage.EntityClassStorage;
import com.xforceplus.ultraman.oqsengine.metadata.dto.storage.ProfileStorage;
import com.xforceplus.ultraman.oqsengine.metadata.utils.CacheUtils;
import com.xforceplus.ultraman.oqsengine.metadata.utils.storage.CacheToStorageGenerator;
import com.xforceplus.ultraman.oqsengine.pojo.define.OperationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityField;
import io.lettuce.core.RedisClient;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCacheExecutor
implements CacheExecutor {
    final Logger logger = LoggerFactory.getLogger(DefaultCacheExecutor.class);
    @Resource(name="redisClientState")
    private RedisClient redisClient;
    @Resource
    private RedisLuaScriptWatchDog redisLuaScriptWatchDog;
    public static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new DeserializationFeature[]{DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS})).enable(new DeserializationFeature[]{DeserializationFeature.USE_LONG_FOR_INTS})).build();
    private StatefulRedisConnection<String, String> syncConnect;
    private RedisCommands<String, String> syncCommands;
    private CacheContext cacheContext;
    private int maxWait = 10;
    private int versionCacheRefreshDuration = 10;
    private PollingThreadExecutor<Void> lifeCycleThread;
    private int prepareExpire = 60;
    private int logExpire = 7;
    private int maxCacheSize = 1024;
    private int fixedDayExpire = 86400;
    private int cacheExpire = 360 * this.fixedDayExpire;
    private String prepareVersionScriptSha;
    private String versionResetScriptSha;
    private String versionGetByEntityScriptSha;
    private String entityClassStorageScriptSha;
    private String entityClassStorageListScriptSha;
    private final String appEnvKeys;
    private final String appCodeKeys;
    private final String appVersionKeys;
    private final String appPrepareKeyPrefix;
    private final String appEntityMappingKey;
    private final String appEntityCollectionsKey;
    private final String entityStorageKeys;
    private final String upGradeLogKey;

    public DefaultCacheExecutor() {
        this(0, 0, 0, "com.xforceplus.ultraman.oqsengine.metadata.app.env", "com.xforceplus.ultraman.oqsengine.metadata.versions", "com.xforceplus.ultraman.oqsengine.metadata.prepare", "com.xforceplus.ultraman.oqsengine.metadata.entity", "com.xforceplus.ultraman.oqsengine.metadata.entity.app.rel", "com.xforceplus.ultraman.oqsengine.metadata.app.version.entityIds", "com.xforceplus.ultraman.oqsengine.metadata.app.code", "com.xforceplus.ultraman.oqsengine.metadata.upgrade.log");
    }

    public DefaultCacheExecutor(int maxCacheSize, int prepareExpireSeconds, int cacheExpireSeconds) {
        this(maxCacheSize, prepareExpireSeconds, cacheExpireSeconds, "com.xforceplus.ultraman.oqsengine.metadata.app.env", "com.xforceplus.ultraman.oqsengine.metadata.versions", "com.xforceplus.ultraman.oqsengine.metadata.prepare", "com.xforceplus.ultraman.oqsengine.metadata.entity", "com.xforceplus.ultraman.oqsengine.metadata.entity.app.rel", "com.xforceplus.ultraman.oqsengine.metadata.app.version.entityIds", "com.xforceplus.ultraman.oqsengine.metadata.app.code", "com.xforceplus.ultraman.oqsengine.metadata.upgrade.log");
    }

    public DefaultCacheExecutor(int maxCacheSize, int prepareExpireSeconds, int cacheExpireSeconds, String appEnvKeys, String appVersionKeys, String appPrepareKeyPrefix, String entityStorageKeys, String appEntityMappingKey, String appEntityCollectionsKey, String appCodeKeys, String upGradeLogKey) {
        if (maxCacheSize > 0) {
            this.maxCacheSize = maxCacheSize;
        }
        if (prepareExpireSeconds > 0) {
            this.prepareExpire = prepareExpireSeconds;
        }
        if (cacheExpireSeconds > 0) {
            this.cacheExpire = cacheExpireSeconds;
        }
        this.appEnvKeys = appEnvKeys;
        if (this.appEnvKeys == null || this.appEnvKeys.isEmpty()) {
            throw new IllegalArgumentException("The metadataAppEnv keys is invalid.");
        }
        this.appVersionKeys = appVersionKeys;
        if (this.appVersionKeys == null || this.appVersionKeys.isEmpty()) {
            throw new IllegalArgumentException("The metadataVersion keys is invalid.");
        }
        this.appPrepareKeyPrefix = appPrepareKeyPrefix;
        if (this.appPrepareKeyPrefix == null || this.appPrepareKeyPrefix.isEmpty()) {
            throw new IllegalArgumentException("The metadataPrepare key is invalid.");
        }
        this.entityStorageKeys = entityStorageKeys;
        if (this.entityStorageKeys == null || this.entityStorageKeys.isEmpty()) {
            throw new IllegalArgumentException("The metadataAppEntity key is invalid.");
        }
        this.appEntityMappingKey = appEntityMappingKey;
        if (this.appEntityMappingKey == null || this.appEntityMappingKey.isEmpty()) {
            throw new IllegalArgumentException("The metadataAppRel key is invalid.");
        }
        this.appEntityCollectionsKey = appEntityCollectionsKey;
        if (this.appEntityCollectionsKey == null || this.appEntityCollectionsKey.isEmpty()) {
            throw new IllegalArgumentException("The appEntityCollections key is invalid.");
        }
        this.appCodeKeys = appCodeKeys;
        if (this.appCodeKeys == null || this.appCodeKeys.isEmpty()) {
            throw new IllegalArgumentException("The appCodeKeys keys is invalid.");
        }
        this.upGradeLogKey = upGradeLogKey;
        if (this.upGradeLogKey == null || this.upGradeLogKey.isEmpty()) {
            throw new IllegalArgumentException("The upGradeLogKey keys is invalid.");
        }
        this.cacheContext = new CacheContext(this.maxCacheSize, this.cacheExpire);
    }

    @PostConstruct
    public void init() {
        if (this.redisClient == null) {
            throw new IllegalStateException("Invalid redisClient.");
        }
        this.syncConnect = this.redisClient.connect();
        this.syncCommands = this.syncConnect.sync();
        this.syncCommands.clientSetname((Object)"oqs.sync.metadata");
        if (this.redisLuaScriptWatchDog != null) {
            this.prepareVersionScriptSha = this.redisLuaScriptWatchDog.watch(RedisLuaScript.PREPARE_VERSION_SCRIPT);
            this.versionGetByEntityScriptSha = this.redisLuaScriptWatchDog.watch(RedisLuaScript.ACTIVE_VERSION);
            this.versionResetScriptSha = this.redisLuaScriptWatchDog.watch(RedisLuaScript.REST_VERSION);
            this.entityClassStorageScriptSha = this.redisLuaScriptWatchDog.watch(RedisLuaScript.ENTITY_CLASS_STORAGE_INFO);
            this.entityClassStorageListScriptSha = this.redisLuaScriptWatchDog.watch(RedisLuaScript.ENTITY_CLASS_STORAGE_INFO_LIST);
        } else {
            this.prepareVersionScriptSha = this.syncCommands.scriptLoad(RedisLuaScript.PREPARE_VERSION_SCRIPT);
            this.versionGetByEntityScriptSha = this.syncCommands.scriptLoad(RedisLuaScript.ACTIVE_VERSION);
            this.versionResetScriptSha = this.syncCommands.scriptLoad(RedisLuaScript.REST_VERSION);
            this.entityClassStorageScriptSha = this.syncCommands.scriptLoad(RedisLuaScript.ENTITY_CLASS_STORAGE_INFO);
            this.entityClassStorageListScriptSha = this.syncCommands.scriptLoad(RedisLuaScript.ENTITY_CLASS_STORAGE_INFO_LIST);
        }
        this.lifeCycleThread = new PollingThreadExecutor("metaVersionCached", this.versionCacheRefreshDuration, TimeUnit.SECONDS, this.maxWait, n -> this.cachedVersion(), null);
        this.lifeCycleThread.start();
    }

    @PreDestroy
    public void destroy() {
        this.syncConnect.close();
        this.lifeCycleThread.stop();
    }

    @Override
    public MetaChangePayLoad save(String appId, String env, int version, List<EntityClassStorage> storageList) throws JsonProcessingException {
        MetaChangePayLoad appMetaChangePayLoad = new MetaChangePayLoad(appId, version);
        int oldVersion = this.version(appId);
        Map<Long, EntityClassStorage> oldMetas = null;
        if (oldVersion > -1) {
            oldMetas = CacheToStorageGenerator.toEntityClassStorages(OBJECT_MAPPER, this.remoteMultiplyLoading(this.appEntityIdList(appId, oldVersion), oldVersion));
        }
        String appCode = "";
        for (EntityClassStorage newStorage : storageList) {
            EntityClassStorage old;
            appCode = newStorage.getAppCode();
            EntityClassStorage entityClassStorage = old = null != oldMetas ? oldMetas.remove(newStorage.getId()) : null;
            MetaChangePayLoad.EntityChange entityChange = this.saveToCache(this.toCacheSetKey(version, newStorage.getId()), old, newStorage);
            if (null == entityChange) continue;
            appMetaChangePayLoad.getEntityChanges().add(entityChange);
        }
        if (null != oldMetas) {
            oldMetas.forEach((k, v) -> {
                MetaChangePayLoad.EntityChange entityChange = new MetaChangePayLoad.EntityChange(k);
                this.reverseEventCheck((EntityClassStorage)v, null, null, entityChange);
                appMetaChangePayLoad.getEntityChanges().add(entityChange);
            });
        }
        if (!this.resetVersion(appId, version, storageList.stream().map(EntityClassStorage::getId).collect(Collectors.toList()))) {
            throw new RuntimeException(String.format("reset version failed, appId : %s, %d", appId, version));
        }
        if (!appCode.isEmpty()) {
            this.saveAppCode(appId, appCode);
        }
        this.addUpGradeLog(appId, env, version);
        return appMetaChangePayLoad;
    }

    @Override
    public Map<String, String> remoteRead(long entityClassId) throws JsonProcessingException {
        int version = this.version(entityClassId, false);
        return this.remoteRead(entityClassId, version);
    }

    @Override
    public Map<String, String> remoteRead(long entityClassId, int version) throws JsonProcessingException {
        Object[] keys = new String[]{this.entityStorageKeys};
        String redisValue = (String)this.syncCommands.evalsha(this.entityClassStorageScriptSha, ScriptOutputType.VALUE, keys, (Object[])new String[]{version + "", Long.toString(entityClassId)});
        return (Map)OBJECT_MAPPER.readValue(redisValue, Map.class);
    }

    @Override
    public Map<String, Map<String, String>> multiRemoteRead(Collection<Long> ids, int version) throws JsonProcessingException {
        if (null != ids && ids.size() > 0) {
            return this.remoteMultiplyLoading(ids, version);
        }
        return null;
    }

    @Override
    public int version(String appId) {
        String versionStr = (String)this.syncCommands.hget((Object)this.appVersionKeys, (Object)appId);
        if (null != versionStr) {
            return Integer.parseInt(versionStr);
        }
        return -1;
    }

    @Override
    public int version(Long entityClassId, boolean withCache) {
        Integer v;
        if (null == entityClassId || entityClassId <= 0L) {
            return -1;
        }
        if (withCache && null != (v = this.cacheContext.versionCache().get(entityClassId))) {
            return v;
        }
        Object[] keys = new String[]{this.appEntityMappingKey, this.appVersionKeys};
        String v2 = (String)this.syncCommands.evalsha(this.versionGetByEntityScriptSha, ScriptOutputType.VALUE, keys, (Object[])new String[]{Long.toString(entityClassId)});
        return null != v2 ? Integer.parseInt(v2) : -1;
    }

    @Override
    public Map<Long, Integer> versions(List<Long> entityClassIds, boolean withCache, boolean errorContinue) {
        List<Long> notFoundIds;
        HashMap<Long, Integer> vs = new HashMap<Long, Integer>();
        if (withCache) {
            notFoundIds = new ArrayList<Long>();
            entityClassIds.forEach(id -> {
                Integer v = this.cacheContext.versionCache().get(id);
                if (null != v && v > -1) {
                    vs.put((Long)id, v);
                } else {
                    notFoundIds.add((Long)id);
                }
            });
        } else {
            notFoundIds = entityClassIds;
        }
        if (notFoundIds.isEmpty()) {
            return vs;
        }
        Map entityAppRelations = this.syncCommands.hgetall((Object)this.appEntityMappingKey);
        Map appVersionRelations = this.syncCommands.hgetall((Object)this.appVersionKeys);
        String error = "";
        if (null != appVersionRelations && !appVersionRelations.isEmpty() && null != entityAppRelations && !entityAppRelations.isEmpty()) {
            for (Long entityClassId : notFoundIds) {
                String appId = (String)entityAppRelations.get(String.valueOf(entityClassId));
                if (null != appId) {
                    String version = (String)appVersionRelations.get(appId);
                    if (null != version) {
                        vs.put(entityClassId, Integer.parseInt(version));
                    } else {
                        error = String.format("version not found, appId : %s failed, entityClassId : %s", appId, entityClassId);
                    }
                } else {
                    error = String.format("appId not found, entityClassId : %s", entityClassId);
                }
                if (error.isEmpty()) continue;
                if (errorContinue) {
                    this.logger.warn(error);
                    error = "";
                    continue;
                }
                break;
            }
        } else {
            error = "query entityClassIds->versions failed, no mapping in cache.";
            this.logger.warn(error);
        }
        if (!error.isEmpty() && !errorContinue) {
            throw new RuntimeException(error);
        }
        return vs;
    }

    @Override
    public boolean resetVersion(String appId, int version, List<Long> ids) {
        if (null == appId || appId.isEmpty()) {
            return false;
        }
        if (version < 0) {
            return false;
        }
        Object[] values = null;
        if (null != ids && ids.size() > 0) {
            values = new String[ids.size() + 2];
            int j = 2;
            for (Long id : ids) {
                values[j] = Long.toString(id);
                ++j;
            }
        } else {
            values = new String[2];
        }
        Object[] keys = new String[]{this.appEntityMappingKey, this.appVersionKeys};
        values[0] = appId;
        values[1] = Integer.toString(version);
        boolean ret = (Boolean)this.syncCommands.evalsha(this.versionResetScriptSha, ScriptOutputType.BOOLEAN, keys, values);
        if (ret) {
            try {
                String fieldName = String.format("%s.%d", appId, version);
                this.syncCommands.hset((Object)this.appEntityCollectionsKey, (Object)fieldName, (Object)OBJECT_MAPPER.writeValueAsString(ids));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public boolean prepare(String appId, int version) {
        if (null == appId || appId.isEmpty()) {
            this.logger.warn("prepare appId is empty.");
            return false;
        }
        if (version < 0) {
            this.logger.warn("prepare [{}] failed, version [{}] is less than 0", (Object)appId, (Object)version);
            return false;
        }
        Object[] keys = new String[]{this.appVersionKeys, this.appPrepareKeyPrefix};
        try {
            return (Boolean)this.syncCommands.evalsha(this.prepareVersionScriptSha, ScriptOutputType.BOOLEAN, keys, (Object[])new String[]{Integer.toString(version), appId, Integer.toString(this.prepareExpire)});
        }
        catch (Exception e) {
            this.logger.warn("do prepare [{}]-[{}] failed, message [{}]", new Object[]{appId, version, e.toString()});
            throw e;
        }
    }

    @Override
    public boolean endPrepare(String appId) {
        if (null == appId || appId.isEmpty()) {
            return false;
        }
        try {
            return this.syncCommands.del((Object[])new String[]{String.format("%s.%s", this.appPrepareKeyPrefix, appId)}) > 0L;
        }
        catch (Exception e) {
            this.logger.warn("end prepare [{}] failed, message [{}]", (Object)appId, (Object)e.toString());
            return false;
        }
    }

    @Override
    public String appEnvGet(String appId) {
        return (String)this.syncCommands.hget((Object)this.appEnvKeys, (Object)appId);
    }

    @Override
    public boolean appEnvSet(String appId, String env) {
        return this.syncCommands.hsetnx((Object)this.appEnvKeys, (Object)appId, (Object)env);
    }

    @Override
    public boolean appEnvRemove(String appId) {
        return this.syncCommands.hdel((Object)this.appEnvKeys, (Object[])new String[]{appId}) == 1L;
    }

    @Override
    public void invalidateLocal() {
        this.cacheContext.invalidate();
    }

    @Override
    public boolean clean(String appId, int version, boolean force) {
        int activeVersion;
        if (!force && version >= (activeVersion = this.version(appId))) {
            return false;
        }
        Collection<Long> ids = this.appEntityIdList(appId, version);
        try {
            for (Long id : ids) {
                this.doClean(id, version);
            }
            this.syncCommands.hdel((Object)this.appEntityCollectionsKey, (Object[])new String[]{String.format("%s.%d", appId, version)});
        }
        catch (Exception e) {
            this.logger.warn("{}", (Object)e.toString());
        }
        return true;
    }

    @Override
    public Collection<Long> appEntityIdList(String appId, Integer version) {
        String fieldName = String.format("%s.%d", appId, version);
        String v = (String)this.syncCommands.hget((Object)this.appEntityCollectionsKey, (Object)fieldName);
        if (null != v && !v.isEmpty()) {
            try {
                return (Collection)OBJECT_MAPPER.readValue(v, OBJECT_MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{Long.class}));
            }
            catch (Exception e) {
                this.logger.warn("{}", (Object)e.toString());
            }
        }
        return new ArrayList<Long>();
    }

    @Override
    public Optional<IEntityClass> localRead(long entityClassId, int version, String profile) {
        Map entityClassMap = (Map)this.cacheContext.entityClassStorageCache().getIfPresent((Object)CacheUtils.generateEntityCacheKey(entityClassId, version));
        if (null != entityClassMap) {
            return Optional.ofNullable((IEntityClass)entityClassMap.get(CacheUtils.generateEntityCacheInternalKey(profile)));
        }
        return Optional.empty();
    }

    @Override
    public List<String> readProfileCodes(long entityClassId, int version) {
        String key = CacheUtils.generateEntityCacheKey(entityClassId, version);
        List<String> profiles = (List<String>)this.cacheContext.profileCache().getIfPresent((Object)key);
        if (null == profiles) {
            try {
                profiles = CacheUtils.parseProfileCodes(this.remoteRead(entityClassId, version));
                this.cacheContext.profileCache().put((Object)key, profiles);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("entityId : %d, version : %d, read profiles failed, message : %s", entityClassId, version, e.getMessage()));
            }
        }
        return profiles;
    }

    @Override
    public void localStorage(long entityClassId, int version, String profile, IEntityClass entityClass) {
        String key = CacheUtils.generateEntityCacheKey(entityClassId, version);
        Map e = (Map)this.cacheContext.entityClassStorageCache().getIfPresent((Object)key);
        if (null == e) {
            HashMap<String, IEntityClass> internals = new HashMap<String, IEntityClass>();
            internals.put(CacheUtils.generateEntityCacheInternalKey(profile), entityClass);
            this.cacheContext.entityClassStorageCache().put((Object)key, internals);
        } else {
            e.putIfAbsent(CacheUtils.generateEntityCacheInternalKey(profile), entityClass);
        }
    }

    @Override
    public List<AppSimpleInfo> showAppInfo() {
        ArrayList<AppSimpleInfo> infoList = new ArrayList<AppSimpleInfo>();
        Map envs = this.syncCommands.hgetall((Object)this.appEnvKeys);
        if (null != envs && !envs.isEmpty()) {
            Map versions = this.syncCommands.hgetall((Object)this.appVersionKeys);
            Map codes = this.syncCommands.hgetall((Object)this.appCodeKeys);
            envs.forEach((appId, env) -> {
                String version = null;
                if (null != versions && !versions.isEmpty()) {
                    version = (String)versions.remove(appId);
                }
                String code = null;
                if (null != codes && !codes.isEmpty()) {
                    code = (String)codes.remove(appId);
                }
                infoList.add(new AppSimpleInfo((String)appId, (String)env, null != code ? code : "", null != version ? Integer.parseInt(version) : -1));
            });
        }
        return infoList;
    }

    @Override
    public Collection<UpGradeLog> showUpgradeLogs(String appId, String env) throws JsonProcessingException {
        ArrayList<UpGradeLog> upGradeLogs = new ArrayList<UpGradeLog>();
        if (null != appId && !appId.isEmpty() && null != env && !env.isEmpty()) {
            String fieldKey = String.format("%s.%s", appId, env);
            UpGradeLog upGradeLog = this.getUpgradeLog(fieldKey);
            if (null != upGradeLog) {
                upGradeLogs.add(upGradeLog);
            }
        } else {
            Map vs = this.syncCommands.hgetall((Object)this.upGradeLogKey);
            if (null != vs) {
                for (String v : vs.values()) {
                    upGradeLogs.add((UpGradeLog)OBJECT_MAPPER.readValue(v, UpGradeLog.class));
                }
            }
        }
        return upGradeLogs;
    }

    private UpGradeLog getUpgradeLog(String fieldKey) throws JsonProcessingException {
        String v = (String)this.syncCommands.hget((Object)this.upGradeLogKey, (Object)fieldKey);
        if (null != v) {
            return (UpGradeLog)OBJECT_MAPPER.readValue(v, UpGradeLog.class);
        }
        return null;
    }

    private void addUpGradeLog(String appId, String env, int currentVersion) {
        try {
            String fieldKey = String.format("%s.%s", appId, env);
            UpGradeLog upGradeLog = this.getUpgradeLog(fieldKey);
            if (null == upGradeLog) {
                long time = System.currentTimeMillis();
                upGradeLog = new UpGradeLog(appId, env, currentVersion, time, currentVersion, time);
            } else {
                upGradeLog.setCurrentVersion(currentVersion);
                upGradeLog.setCurrentTimeStamp(System.currentTimeMillis());
            }
            String finalValue = OBJECT_MAPPER.writeValueAsString((Object)upGradeLog);
            this.syncCommands.hset((Object)this.upGradeLogKey, (Object)fieldKey, (Object)finalValue);
        }
        catch (Exception e) {
            this.logger.warn("add upgrade log failed, appId : {}, env : {}, version : {}, message : {}", new Object[]{appId, env, currentVersion, e.getMessage()});
        }
    }

    private void saveAppCode(String appId, String appCode) {
        this.syncCommands.hset((Object)this.appCodeKeys, (Object)appId, (Object)appCode);
    }

    private boolean doClean(Long entityId, int version) {
        if (null == entityId) {
            return false;
        }
        if (version < 0) {
            return false;
        }
        this.localInvalidate(entityId, version);
        boolean isDelete = this.remoteInvalidate(entityId, version);
        if (!isDelete) {
            this.logger.warn("delete remote failed, entityId:[{}], version:[{}]", (Object)entityId, (Object)version);
        }
        return true;
    }

    private boolean remoteInvalidate(Long entityId, int version) {
        String keys = String.format("%s.%d.%d", this.entityStorageKeys, version, entityId);
        try {
            List entityClassKeys = this.syncCommands.hkeys((Object)keys);
            if (null != entityClassKeys && entityClassKeys.size() > 0) {
                return this.syncCommands.hdel((Object)keys, (Object[])entityClassKeys.toArray(new String[entityClassKeys.size()])) == (long)entityClassKeys.size();
            }
            return true;
        }
        catch (Exception e) {
            this.logger.warn("delete remote failed, entityId:[{}], version:[{}], message:[{}]", new Object[]{entityId, version, e.getMessage()});
            return false;
        }
    }

    private Map<String, Map<String, String>> remoteMultiplyLoading(Collection<Long> ids, int version) throws JsonProcessingException {
        int extraSize = ids.size();
        Object[] extraEntityIds = new String[extraSize + 1];
        extraEntityIds[0] = version + "";
        int j = 1;
        for (Long id : ids) {
            extraEntityIds[j++] = Long.toString(id);
        }
        Object[] keys = new String[]{this.entityStorageKeys};
        String redisValue = (String)this.syncCommands.evalsha(this.entityClassStorageListScriptSha, ScriptOutputType.VALUE, keys, extraEntityIds);
        Map valuePairs = (Map)OBJECT_MAPPER.readValue(redisValue, Map.class);
        if (extraSize != valuePairs.size()) {
            throw new RuntimeException(String.format("missed some extend or children entityClassStorage, should be [%d], actual [%d] ", extraSize, valuePairs.size()));
        }
        return valuePairs;
    }

    private void localInvalidate(long entityId, int version) {
        try {
            this.cacheContext.entityClassStorageCache().invalidate((Object)CacheUtils.generateEntityCacheKey(entityId, version));
            this.cacheContext.entityClassStorageCache().invalidate((Object)CacheUtils.generateEntityCacheKey(entityId, version));
            this.cacheContext.versionCache().remove(entityId);
        }
        catch (Exception e) {
            this.logger.warn("delete local failed, entityId:[{}], version:[{}], message:[{}]", new Object[]{entityId, version, e.getMessage()});
        }
    }

    private MetaChangePayLoad.FieldChange toFieldChange(IEntityField oldOne, IEntityField newOne, String profile) {
        if (null == oldOne && null == newOne) {
            throw new RuntimeException("add event could not handle IEntityField oldOne & newOne all empty.");
        }
        if (null == oldOne) {
            return new MetaChangePayLoad.FieldChange(Long.valueOf(newOne.id()), OperationType.CREATE, profile);
        }
        if (null == newOne) {
            return new MetaChangePayLoad.FieldChange(Long.valueOf(oldOne.id()), OperationType.DELETE, profile);
        }
        if (!oldOne.toString().equals(newOne.toString())) {
            return new MetaChangePayLoad.FieldChange(Long.valueOf(newOne.id()), OperationType.UPDATE, profile);
        }
        return null;
    }

    private MetaChangePayLoad.EntityChange saveToCache(String key, EntityClassStorage oldStorage, EntityClassStorage newStorage) {
        String entityFieldStr;
        MetaChangePayLoad.EntityChange entityChange = null;
        this.syncCommands.hset((Object)key, (Object)"id", (Object)Long.toString(newStorage.getId()));
        this.syncCommands.hset((Object)key, (Object)"appCode", (Object)newStorage.getAppCode());
        this.syncCommands.hset((Object)key, (Object)"type", (Object)Integer.toString(newStorage.getType()));
        this.syncCommands.hset((Object)key, (Object)"code", (Object)newStorage.getCode());
        this.syncCommands.hset((Object)key, (Object)"name", (Object)newStorage.getName());
        this.syncCommands.hset((Object)key, (Object)"level", (Object)Integer.toString(newStorage.getLevel()));
        this.syncCommands.hset((Object)key, (Object)"version", (Object)Integer.toString(newStorage.getVersion()));
        if (null != newStorage.getFatherId()) {
            this.syncCommands.hset((Object)key, (Object)"father", (Object)Long.toString(newStorage.getFatherId()));
            if (null != newStorage.getAncestors() && newStorage.getAncestors().size() > 0) {
                try {
                    String ancestorStr = OBJECT_MAPPER.writeValueAsString(newStorage.getAncestors());
                    this.syncCommands.hset((Object)key, (Object)"ancestors", (Object)ancestorStr);
                }
                catch (JsonProcessingException e) {
                    throw new MetaSyncClientException("parse ancestors failed.", false);
                }
            }
        }
        if (null != newStorage.getRelations() && newStorage.getRelations().size() > 0) {
            try {
                String relationStr = OBJECT_MAPPER.writeValueAsString(newStorage.getRelations());
                this.syncCommands.hset((Object)key, (Object)"relations", (Object)relationStr);
            }
            catch (JsonProcessingException e) {
                throw new MetaSyncClientException("parse relations failed.", false);
            }
        }
        if (null != newStorage.getFields()) {
            for (IEntityField iEntityField : newStorage.getFields()) {
                try {
                    EntityField oldField = null == oldStorage ? null : oldStorage.find(iEntityField.id(), null);
                    MetaChangePayLoad.FieldChange fieldChange = this.toFieldChange((IEntityField)oldField, iEntityField, null);
                    if (null != fieldChange) {
                        if (null == entityChange) {
                            entityChange = new MetaChangePayLoad.EntityChange(Long.valueOf(newStorage.getId()));
                        }
                        entityChange.getFieldChanges().add(fieldChange);
                    }
                    entityFieldStr = OBJECT_MAPPER.writeValueAsString((Object)iEntityField);
                    this.syncCommands.hset((Object)key, (Object)("fields." + iEntityField.id()), (Object)entityFieldStr);
                }
                catch (JsonProcessingException e) {
                    throw new MetaSyncClientException("parse entityField failed.", false);
                }
            }
        }
        if (null != newStorage.getProfileStorageMap() && !newStorage.getProfileStorageMap().isEmpty()) {
            for (ProfileStorage profileStorage : newStorage.getProfileStorageMap().values()) {
                if (null != profileStorage.getEntityFieldList() && !profileStorage.getEntityFieldList().isEmpty()) {
                    for (IEntityField iEntityField : profileStorage.getEntityFieldList()) {
                        try {
                            entityFieldStr = OBJECT_MAPPER.writeValueAsString((Object)iEntityField);
                            this.syncCommands.hset((Object)key, (Object)CacheUtils.generateProfileEntity(profileStorage.getCode(), iEntityField.id()), (Object)entityFieldStr);
                            EntityField oldField = null == oldStorage ? null : oldStorage.find(iEntityField.id(), profileStorage.getCode());
                            MetaChangePayLoad.FieldChange change = this.toFieldChange((IEntityField)oldField, iEntityField, profileStorage.getCode());
                            if (null == change) continue;
                            if (null == entityChange) {
                                entityChange = new MetaChangePayLoad.EntityChange(Long.valueOf(newStorage.getId()));
                            }
                            entityChange.getFieldChanges().add(change);
                        }
                        catch (JsonProcessingException e) {
                            throw new MetaSyncClientException("parse profile-entityFields failed.", false);
                        }
                    }
                }
                if (null == profileStorage.getRelationStorageList() || profileStorage.getRelationStorageList().isEmpty()) continue;
                try {
                    String relationStr = OBJECT_MAPPER.writeValueAsString(profileStorage.getRelationStorageList());
                    this.syncCommands.hset((Object)key, (Object)CacheUtils.generateProfileRelations(profileStorage.getCode()), (Object)relationStr);
                }
                catch (JsonProcessingException e) {
                    throw new MetaSyncClientException("parse profile-relations failed.", false);
                }
            }
        }
        if (null != oldStorage) {
            if (null == entityChange) {
                entityChange = new MetaChangePayLoad.EntityChange(Long.valueOf(oldStorage.getId()));
            }
            this.reverseEventCheck(oldStorage, newStorage.getFields(), newStorage.getProfileStorageMap(), entityChange);
        }
        return entityChange;
    }

    private void reverseEventCheck(EntityClassStorage oldStorage, List<EntityField> newFields, Map<String, ProfileStorage> newProfiles, MetaChangePayLoad.EntityChange entityChange) {
        oldStorage.getFields().forEach(f -> this.findAndAddEvent((IEntityField)f, newFields, null, entityChange));
        oldStorage.getProfileStorageMap().forEach((k, v) -> {
            ProfileStorage newProfile = null != newProfiles ? (ProfileStorage)newProfiles.get(k) : null;
            v.getEntityFieldList().forEach(e -> this.findAndAddEvent((IEntityField)e, null != newProfile ? newProfile.getEntityFieldList() : null, (String)k, entityChange));
        });
    }

    private void findAndAddEvent(IEntityField origin, List<EntityField> newFields, String profile, MetaChangePayLoad.EntityChange entityChange) {
        IEntityField findEntityField = null;
        if (null != newFields) {
            findEntityField = newFields.stream().filter(n -> n.id() == origin.id()).findFirst().orElse(null);
        }
        if (null == findEntityField) {
            MetaChangePayLoad.FieldChange change = this.toFieldChange(origin, null, profile);
            entityChange.getFieldChanges().add(change);
        }
    }

    private String toCacheSetKey(int version, long id) {
        return this.entityStorageKeys + "." + version + "." + id;
    }

    private void cachedVersion() {
        Map appEnvMaps = this.syncCommands.hgetall((Object)this.appEntityCollectionsKey);
        appEnvMaps.forEach((key, value) -> {
            int version = this.splitAppVersion((String)key);
            if (version > -1) {
                try {
                    List ids = (List)OBJECT_MAPPER.readValue(value, OBJECT_MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{Long.class}));
                    ids.forEach(id -> this.cacheContext.versionCache().put((Long)id, version));
                }
                catch (JsonProcessingException e) {
                    this.logger.warn("cache version json error, message : {}", (Object)e.getMessage());
                }
            }
        });
    }

    private int splitAppVersion(String key) {
        try {
            String[] datas = key.split("\\.");
            if (datas.length == 2) {
                return Integer.parseInt(datas[1]);
            }
        }
        catch (Exception e) {
            this.logger.warn("key {}, split appVersion failed, message : {}", (Object)key, (Object)e.getMessage());
        }
        return -1;
    }

    private String toNowDateString(LocalDate date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        return formatter.format(date);
    }
}

