/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata.mock;

import com.google.protobuf.InvalidProtocolBufferException;
import com.xforceplus.ultraman.oqsengine.metadata.MetaManager;
import com.xforceplus.ultraman.oqsengine.metadata.dto.metrics.MetaMetrics;
import com.xforceplus.ultraman.oqsengine.metadata.utils.offline.OffLineMetaHelper;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class MockMetaManager
implements MetaManager {
    private Map<String, IEntityClass> entityClassPool = new ConcurrentHashMap<String, IEntityClass>();
    private Map<String, IEntityClass> profileEntityClassPool = new ConcurrentHashMap<String, IEntityClass>();

    public void addEntityClass(IEntityClass entityClass) {
        entityClass.family().stream().forEach(e -> this.entityClassPool.put(this.buildKey(e.id(), e.version()), (IEntityClass)e));
    }

    public void addEntityClass(IEntityClass entityClass, String profile) {
        if (profile == null) {
            this.addEntityClass(entityClass);
        } else {
            entityClass.family().stream().forEach(e -> this.entityClassPool.put(this.buildKey(e.id(), e.version(), profile), (IEntityClass)e));
        }
    }

    public Optional<IEntityClass> load(long id) {
        Optional<Map.Entry> op = this.entityClassPool.entrySet().stream().filter(e -> ((IEntityClass)e.getValue()).id() == id).max((e0, e1) -> {
            if (((IEntityClass)e0.getValue()).version() < ((IEntityClass)e1.getValue()).version()) {
                return -1;
            }
            if (((IEntityClass)e0.getValue()).version() > ((IEntityClass)e1.getValue()).version()) {
                return 1;
            }
            return 0;
        });
        if (op.isPresent()) {
            return Optional.ofNullable((IEntityClass)op.get().getValue());
        }
        return Optional.empty();
    }

    @Override
    public Optional<IEntityClass> load(long id, String profile) {
        if (profile == null || profile.isEmpty()) {
            return this.load(id);
        }
        Optional<Map.Entry> op = this.profileEntityClassPool.entrySet().stream().filter(e -> ((IEntityClass)e.getValue()).id() == id).max((e0, e1) -> {
            if (((IEntityClass)e0.getValue()).version() < ((IEntityClass)e1.getValue()).version()) {
                return -1;
            }
            if (((IEntityClass)e0.getValue()).version() > ((IEntityClass)e1.getValue()).version()) {
                return 1;
            }
            return 0;
        });
        if (op.isPresent()) {
            return Optional.ofNullable((IEntityClass)op.get().getValue());
        }
        return Optional.empty();
    }

    @Override
    public Optional<IEntityClass> load(long entityClassId, int version, String profile) {
        if (profile == null || profile.isEmpty()) {
            return this.load(entityClassId, version, profile);
        }
        Optional<Map.Entry> op = this.profileEntityClassPool.entrySet().stream().filter(e -> ((IEntityClass)e.getValue()).id() == entityClassId).max((e0, e1) -> {
            if (((IEntityClass)e0.getValue()).version() < ((IEntityClass)e1.getValue()).version()) {
                return -1;
            }
            if (((IEntityClass)e0.getValue()).version() > ((IEntityClass)e1.getValue()).version()) {
                return 1;
            }
            return 0;
        });
        if (op.isPresent()) {
            return Optional.ofNullable((IEntityClass)op.get().getValue());
        }
        return Optional.empty();
    }

    @Override
    public Collection<IEntityClass> withProfilesLoad(long entityClassId) {
        return null;
    }

    @Override
    public int need(String appId, String env) {
        return 0;
    }

    @Override
    public int need(String appId, String env, boolean overWrite) {
        return 0;
    }

    @Override
    public void invalidateLocal() {
        this.entityClassPool.clear();
        this.profileEntityClassPool.clear();
    }

    @Override
    public boolean metaImport(String appId, String env, int version, String content) {
        try {
            OffLineMetaHelper.toEntityClassSyncRspProto(content);
            return true;
        }
        catch (InvalidProtocolBufferException e) {
            return false;
        }
    }

    @Override
    public Optional<MetaMetrics> showMeta(String appId) {
        return Optional.empty();
    }

    @Override
    public int reset(String appId, String env) {
        return 0;
    }

    @Override
    public boolean remove(String appId) {
        return true;
    }

    private String buildKey(long id, int version) {
        return this.buildKey(id, version, null);
    }

    private String buildKey(long id, int version, String profile) {
        if (profile != null) {
            return String.format("%d-%d-%s", id, version, profile);
        }
        return String.format("%d-%d", id, version);
    }
}

