/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata.utils;

import com.xforceplus.ultraman.oqsengine.meta.common.exception.MetaSyncClientException;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.AbstractCalculation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.AutoFill;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.StaticCalculation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CacheUtils {
    private static final String ENTITY_STORAGE_LOCAL_CACHE_KEY = "entityStorageLocal";
    private static final String ENTITY_STORAGE_LOCAL_CACHE_INTERNAL_KEY = ".";
    private static final int PROFILE_ENTITY_KEY_PARTS = 4;
    private static final int PROFILE_RELATION_KEY_PARTS = 3;
    private static final int PROFILE_CODE_POS = 2;

    public static boolean validBusinessId(String id) {
        try {
            return null != id && !id.isEmpty() && Long.parseLong(id) >= 1L;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean validBusinessId(Long id) {
        return null != id && id >= 1L;
    }

    public static String generateEntityCacheInternalKey(String profile) {
        return ENTITY_STORAGE_LOCAL_CACHE_INTERNAL_KEY + (null == profile ? "" : profile);
    }

    public static String generateEntityCacheKey(long entityId, int version) {
        return "entityStorageLocal." + entityId + ENTITY_STORAGE_LOCAL_CACHE_INTERNAL_KEY + version;
    }

    public static String generateProfileEntity(String code, long id) {
        return "profiles.fields." + code + ENTITY_STORAGE_LOCAL_CACHE_INTERNAL_KEY + id;
    }

    public static String parseOneKeyFromProfileEntity(String key) {
        String[] parts = key.split("\\.");
        if (parts.length != 4) {
            throw new MetaSyncClientException(String.format("profileEntity key's length should be %d", 4), false);
        }
        return parts[2];
    }

    public static String generateProfileRelations(String code) {
        return "profiles.relations." + code;
    }

    public static String parseOneKeyFromProfileRelations(String key) {
        String[] parts = key.split("\\.");
        if (parts.length != 3) {
            throw new MetaSyncClientException(String.format("profileRelations key's length should be %d", 3), false);
        }
        return parts[2];
    }

    public static EntityField resetCalculation(EntityField entityField) {
        if (null != entityField.calculationType()) {
            if (entityField.calculationType().equals((Object)CalculationType.AUTO_FILL)) {
                AutoFill autoFill = (AutoFill)entityField.config().getCalculation();
                if (autoFill.getDomainNoType() == null) {
                    autoFill.setDomainNoType(AutoFill.DomainNoType.NORMAL);
                }
                if (autoFill.getLevel() == 0) {
                    autoFill.setLevel(1);
                }
            }
        } else {
            entityField.config().resetCalculation((AbstractCalculation)StaticCalculation.Builder.anStaticCalculation().build());
        }
        return entityField;
    }

    public static List<String> parseProfileCodes(Map<String, String> keyValues) {
        if (null != keyValues && !keyValues.isEmpty()) {
            HashSet<String> profiles = new HashSet<String>();
            for (Map.Entry<String, String> entry : keyValues.entrySet()) {
                if (entry.getKey().startsWith("profiles.fields")) {
                    profiles.add(CacheUtils.parseOneKeyFromProfileEntity(entry.getKey()));
                    continue;
                }
                if (!entry.getKey().startsWith("profiles.relations")) continue;
                profiles.add(CacheUtils.parseOneKeyFromProfileRelations(entry.getKey()));
            }
            return new ArrayList<String>(profiles);
        }
        return Collections.emptyList();
    }
}

