/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class CacheContext {
    private final Cache<String, Map<String, IEntityClass>> entityClassStorageCache;
    private final Cache<String, List<String>> profileCache;
    private Map<Long, Integer> versions;

    public CacheContext(int maxCacheSize, int cacheExpire) {
        this.entityClassStorageCache = this.initCache(maxCacheSize, cacheExpire);
        this.profileCache = this.initCache(maxCacheSize, cacheExpire);
        this.versions = new ConcurrentHashMap<Long, Integer>();
    }

    public void invalidate() {
        this.entityClassStorageCache.invalidateAll();
        this.profileCache.invalidateAll();
        this.versions.clear();
    }

    private <V> Cache<String, V> initCache(int maxCacheSize, int cacheExpire) {
        return CacheBuilder.newBuilder().maximumSize((long)maxCacheSize).expireAfterAccess((long)cacheExpire, TimeUnit.SECONDS).build();
    }

    public Cache<String, Map<String, IEntityClass>> entityClassStorageCache() {
        return this.entityClassStorageCache;
    }

    public Cache<String, List<String>> profileCache() {
        return this.profileCache;
    }

    public Map<Long, Integer> versionCache() {
        return this.versions;
    }
}

