/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata.executor;

import com.xforceplus.ultraman.oqsengine.meta.common.executor.IDelayTaskExecutor;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpireExecutor
implements IDelayTaskExecutor<DelayCleanEntity> {
    final Logger logger = LoggerFactory.getLogger(ExpireExecutor.class);
    private volatile boolean isActive = true;
    private static DelayQueue<DelayCleanEntity> delayTasks = new DelayQueue();

    public DelayCleanEntity take() {
        if (this.isActive) {
            try {
                return (DelayCleanEntity)delayTasks.poll(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.logger.warn("expireExecutor is interrupted, may stop server...");
            }
        }
        return null;
    }

    public void offer(DelayCleanEntity task) {
        if (this.isActive) {
            try {
                delayTasks.offer(task);
            }
            catch (Exception e) {
                this.logger.warn("offer failed, message : {}", (Object)e.getMessage());
            }
        }
    }

    public void stop() {
        this.isActive = false;
    }

    public void start() {
        this.isActive = true;
    }

    public static class DelayCleanEntity
    implements Delayed {
        private Expired expired;
        private long start;
        private long expireTime;

        public DelayCleanEntity(long delayInMillis, Expired expired) {
            this.expired = expired;
            this.start = System.currentTimeMillis();
            this.expireTime = delayInMillis;
        }

        public Expired element() {
            return this.expired;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.start + this.expireTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return (int)(this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS));
        }
    }

    public static class Expired {
        private String appId;
        private int version;

        public Expired(String appId, int version) {
            this.appId = appId;
            this.version = version;
        }

        public String getAppId() {
            return this.appId;
        }

        public int getVersion() {
            return this.version;
        }
    }
}

