/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.xforceplus.ultraman.oqsengine.meta.common.exception.MetaSyncClientException;
import com.xforceplus.ultraman.oqsengine.metadata.cache.CacheExecutor;
import com.xforceplus.ultraman.oqsengine.metadata.cache.DefaultCacheExecutor;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionOperator;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.AbstractCalculation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.Aggregation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.AutoFill;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.StaticCalculation;
import com.xforceplus.ultraman.oqsengine.pojo.utils.IValueUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CacheUtils {
    private static final String ENTITY_STORAGE_LOCAL_CACHE_KEY = "entityStorageLocal";
    private static final String ENTITY_STORAGE_LOCAL_CACHE_INTERNAL_KEY = ".";
    private static final int PROFILE_ENTITY_KEY_PARTS = 4;
    private static final int PROFILE_RELATION_KEY_PARTS = 3;
    private static final int PROFILE_CODE_POS = 2;

    public static boolean validBusinessId(String id) {
        try {
            return null != id && !id.isEmpty() && Long.parseLong(id) >= 1L;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean validBusinessId(Long id) {
        return null != id && id >= 1L;
    }

    public static String generateEntityCacheInternalKey(String profile) {
        return ENTITY_STORAGE_LOCAL_CACHE_INTERNAL_KEY + (null == profile ? "" : profile);
    }

    public static String generateEntityCacheKey(long entityId, int version) {
        return "entityStorageLocal." + entityId + ENTITY_STORAGE_LOCAL_CACHE_INTERNAL_KEY + version;
    }

    public static String generateProfileEntity(String code, long id) {
        return "profiles.fields." + code + ENTITY_STORAGE_LOCAL_CACHE_INTERNAL_KEY + id;
    }

    public static String parseOneKeyFromProfileEntity(String key) {
        String[] parts = key.split("\\.");
        if (parts.length != 4) {
            throw new MetaSyncClientException(String.format("profileEntity key's length should be %d", 4), false);
        }
        return parts[2];
    }

    public static String generateProfileRelations(String code) {
        return "profiles.relations." + code;
    }

    public static String parseOneKeyFromProfileRelations(String key) {
        String[] parts = key.split("\\.");
        if (parts.length != 3) {
            throw new MetaSyncClientException(String.format("profileRelations key's length should be %d", 3), false);
        }
        return parts[2];
    }

    public static EntityField resetCalculation(EntityField entityField, int version, CacheExecutor cacheExecutor) throws JsonProcessingException {
        if (null != entityField.calculationType()) {
            if (entityField.calculationType().equals((Object)CalculationType.AUTO_FILL)) {
                AutoFill autoFill = (AutoFill)entityField.config().getCalculation();
                if (autoFill.getDomainNoType() == null) {
                    autoFill.setDomainNoType(AutoFill.DomainNoType.NORMAL);
                }
                if (autoFill.getLevel() == 0) {
                    autoFill.setLevel(1);
                }
            } else if (entityField.calculationType().equals((Object)CalculationType.AGGREGATION)) {
                Aggregation aggregation = (Aggregation)entityField.config().getCalculation();
                if (null != cacheExecutor && version != -1) {
                    CacheUtils.aggregationConditionsToConditions(aggregation, version, cacheExecutor);
                }
            }
        } else {
            entityField.config().resetCalculation((AbstractCalculation)StaticCalculation.Builder.anStaticCalculation().build());
        }
        return entityField;
    }

    public static List<String> parseProfileCodes(Map<String, String> keyValues) {
        if (null != keyValues && !keyValues.isEmpty()) {
            HashSet<String> profiles = new HashSet<String>();
            for (Map.Entry<String, String> entry : keyValues.entrySet()) {
                if (entry.getKey().startsWith("profiles.fields")) {
                    profiles.add(CacheUtils.parseOneKeyFromProfileEntity(entry.getKey()));
                    continue;
                }
                if (!entry.getKey().startsWith("profiles.relations")) continue;
                profiles.add(CacheUtils.parseOneKeyFromProfileRelations(entry.getKey()));
            }
            return new ArrayList<String>(profiles);
        }
        return Collections.emptyList();
    }

    private static void aggregationConditionsToConditions(Aggregation aggregation, int version, CacheExecutor cacheExecutor) throws JsonProcessingException {
        if (null != aggregation.getAggregationConditions() && !aggregation.getAggregationConditions().isEmpty()) {
            Conditions conditions = Conditions.buildEmtpyConditions();
            for (Aggregation.AggregationCondition aggregationCondition : aggregation.getAggregationConditions()) {
                String fieldStr = cacheExecutor.remoteFieldLoad(aggregationCondition.getEntityClassId(), aggregationCondition.getEntityFieldId(), aggregationCondition.getProfile(), version);
                if (null == fieldStr) {
                    return;
                }
                IEntityField entityField = (IEntityField)DefaultCacheExecutor.OBJECT_MAPPER.readValue(fieldStr, EntityField.class);
                conditions.addAnd(IValueUtils.deserializeCondition((String)aggregationCondition.getStringValue(), (ConditionOperator)aggregationCondition.getConditionOperator(), (IEntityField)entityField));
            }
            aggregation.setConditions(conditions);
        }
    }
}

