/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata.utils.storage;

import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Int64Value;
import com.google.protobuf.StringValue;
import com.xforceplus.ultraman.oqsengine.meta.common.exception.Code;
import com.xforceplus.ultraman.oqsengine.meta.common.exception.MetaSyncClientException;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.Calculator;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.DomainCondition;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassInfo;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncRspProto;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityFieldInfo;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.ProfileInfo;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.RelationInfo;
import com.xforceplus.ultraman.oqsengine.metadata.dto.storage.EntityClassStorage;
import com.xforceplus.ultraman.oqsengine.metadata.dto.storage.ProfileStorage;
import com.xforceplus.ultraman.oqsengine.metadata.dto.storage.RelationStorage;
import com.xforceplus.ultraman.oqsengine.metadata.utils.CacheUtils;
import com.xforceplus.ultraman.oqsengine.metadata.utils.storage.ConditionOperatorMap;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.AggregationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.EntityClassType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldConfig;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.AbstractCalculation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.Aggregation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.AutoFill;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.Formula;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.Lookup;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.StaticCalculation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DateTimeValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.StringsValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class EntityClassStorageBuilderUtils {
    private static final int MIN_FORMULA_LEVEL = 1;

    public static List<EntityClassStorage> protoToStorageList(EntityClassSyncRspProto entityClassSyncRspProto) {
        if (entityClassSyncRspProto.getAppCode().isEmpty()) {
            throw new MetaSyncClientException("appCode is invalid.", false);
        }
        Map<Long, EntityClassStorage> temp = entityClassSyncRspProto.getEntityClassesList().stream().map(ecs -> {
            EntityClassStorage e = EntityClassStorageBuilderUtils.protoValuesToLocalStorage(ecs, entityClassSyncRspProto.getAppCode());
            return e;
        }).collect(Collectors.toMap(EntityClassStorage::getId, s1 -> s1, (s1, s2) -> s1));
        return temp.values().stream().peek(v -> {
            Long fatherId = v.getFatherId();
            while (CacheUtils.validBusinessId(fatherId)) {
                EntityClassStorage entityClassStorage = (EntityClassStorage)temp.get(fatherId);
                if (null == entityClassStorage) {
                    throw new MetaSyncClientException(String.format("entityClass id [%d], father entityClass : [%d] missed.", v.getId(), fatherId), Code.BUSINESS_HANDLER_ERROR.ordinal());
                }
                v.addAncestors(fatherId);
                fatherId = entityClassStorage.getFatherId();
            }
            v.getRelations().forEach(relationStorage -> EntityClassStorageBuilderUtils.relationCheck(v.getId(), temp, relationStorage));
        }).collect(Collectors.toList());
    }

    private static void relationCheck(long id, Map<Long, EntityClassStorage> entityClassStorageMap, RelationStorage relationStorage) {
        if (!CacheUtils.validBusinessId(relationStorage.getRightEntityClassId())) {
            throw new MetaSyncClientException(String.format("entityClass id [%d], relation entityClassId [%d] should not less than 0.", id, relationStorage.getRightEntityClassId()), Code.BUSINESS_HANDLER_ERROR.ordinal());
        }
        if (null == entityClassStorageMap.get(relationStorage.getRightEntityClassId())) {
            throw new MetaSyncClientException(String.format("entityClass id [%d], relation entityClass [%d] missed.", id, relationStorage.getRightEntityClassId()), Code.BUSINESS_HANDLER_ERROR.ordinal());
        }
    }

    private static EntityClassStorage protoValuesToLocalStorage(EntityClassInfo entityClassInfo, String appCode) {
        if (null == entityClassInfo) {
            throw new MetaSyncClientException("entityClassInfo should not be null.", false);
        }
        EntityClassStorage storage = new EntityClassStorage();
        storage.setAppCode(appCode);
        long id = entityClassInfo.getId();
        if (!CacheUtils.validBusinessId(id)) {
            throw new MetaSyncClientException("entityClass-id is invalid.", false);
        }
        storage.setId(id);
        int type = entityClassInfo.getType();
        if (!EntityClassType.validate((int)type)) {
            throw new MetaSyncClientException("entityClass-type is invalid.", false);
        }
        storage.setType(type);
        storage.setCode(entityClassInfo.getCode());
        storage.setName(entityClassInfo.getName());
        storage.setLevel(entityClassInfo.getLevel());
        int version = entityClassInfo.getVersion();
        if (version <= -1) {
            throw new MetaSyncClientException("entityClass-version is invalid.", false);
        }
        storage.setVersion(version);
        if (entityClassInfo.getFather() > 0L) {
            storage.setFatherId(entityClassInfo.getFather());
        }
        storage.setRelations(EntityClassStorageBuilderUtils.toRelationStorageList(entityClassInfo.getRelationsList()));
        storage.setFields(EntityClassStorageBuilderUtils.toEntityFieldList(entityClassInfo.getEntityFieldsList()));
        HashMap<String, ProfileStorage> profileStorageMap = new HashMap<String, ProfileStorage>();
        if (!entityClassInfo.getProfilesList().isEmpty()) {
            for (ProfileInfo p : entityClassInfo.getProfilesList()) {
                if (p.getCode().isEmpty()) {
                    throw new MetaSyncClientException("profile code is invalid.", false);
                }
                ArrayList<EntityField> fieldList = new ArrayList();
                if (!p.getEntityFieldInfoList().isEmpty()) {
                    fieldList = EntityClassStorageBuilderUtils.toEntityFieldList(p.getEntityFieldInfoList());
                }
                ArrayList<RelationStorage> relationStorageList = new ArrayList();
                if (!p.getRelationInfoList().isEmpty()) {
                    relationStorageList = EntityClassStorageBuilderUtils.toRelationStorageList(p.getRelationInfoList());
                }
                profileStorageMap.put(p.getCode(), new ProfileStorage(p.getCode(), fieldList, relationStorageList));
            }
        }
        storage.setProfileStorageMap(profileStorageMap);
        return storage;
    }

    private static List<EntityField> toEntityFieldList(List<EntityFieldInfo> entityFieldInfoList) {
        ArrayList<EntityField> fields = new ArrayList<EntityField>();
        if (null != entityFieldInfoList) {
            for (EntityFieldInfo e : entityFieldInfoList) {
                EntityField entityField = EntityClassStorageBuilderUtils.toEntityField(false, e);
                fields.add(entityField);
            }
        }
        return fields;
    }

    private static List<RelationStorage> toRelationStorageList(List<RelationInfo> relationInfoList) {
        ArrayList<RelationStorage> relations = new ArrayList<RelationStorage>();
        if (null != relationInfoList) {
            for (RelationInfo r : relationInfoList) {
                RelationStorage relation = new RelationStorage();
                relation.setId(r.getId());
                relation.setCode(r.getCode());
                relation.setRightEntityClassId(r.getRightEntityClassId());
                relation.setLeftEntityClassId(r.getLeftEntityClassId());
                relation.setLeftEntityClassCode(r.getLeftEntityClassCode());
                relation.setRelationType(r.getRelationType());
                relation.setIdentity(r.getIdentity());
                if (r.hasEntityField()) {
                    relation.setEntityField(EntityClassStorageBuilderUtils.toEntityField(true, r.getEntityField()));
                }
                relation.setBelongToOwner(r.getBelongToOwner());
                relation.setStrong(r.getStrong());
                relations.add(relation);
            }
        }
        return relations;
    }

    private static EntityField toEntityField(boolean isRelationEntity, EntityFieldInfo e) {
        long eid = e.getId();
        if (!CacheUtils.validBusinessId(eid)) {
            throw new MetaSyncClientException("entityFieldId is invalid.", false);
        }
        FieldType fieldType = FieldType.fromRawType((String)e.getFieldType().name());
        FieldConfig fieldConfig = EntityClassStorageBuilderUtils.toFieldConfig(isRelationEntity, fieldType, e.getId(), e.getFieldConfig(), e.getCalculator());
        return EntityField.Builder.anEntityField().withId(eid).withName(e.getName()).withCnName(e.getCname()).withFieldType(fieldType).withDictId(e.getDictId()).withDefaultValue(e.getDefaultValue()).withConfig(fieldConfig).build();
    }

    private static AbstractCalculation toCalculator(long fieldId, FieldType fieldType, Calculator calculator) {
        CalculationType calculationType = EntityClassStorageBuilderUtils.toCalculationType(calculator);
        switch (calculationType) {
            case AUTO_FILL: {
                return EntityClassStorageBuilderUtils.toAutoFill(fieldId, calculator);
            }
            case FORMULA: {
                return EntityClassStorageBuilderUtils.toFormula(fieldType, calculator);
            }
            case LOOKUP: {
                return EntityClassStorageBuilderUtils.toLookup(fieldId, calculator);
            }
            case AGGREGATION: {
                return EntityClassStorageBuilderUtils.toAggregation(calculator);
            }
        }
        return StaticCalculation.Builder.anStaticCalculation().build();
    }

    private static Lookup toLookup(long fieldId, Calculator calculator) {
        if (!CacheUtils.validBusinessId(calculator.getLookupEntityClassId())) {
            throw new MetaSyncClientException(String.format("[lookup-entityClassId] could not be zero, current-fieldId %d", fieldId), false);
        }
        if (!CacheUtils.validBusinessId(calculator.getLookupEntityFieldId())) {
            throw new MetaSyncClientException(String.format("[lookup-entityField] could not be zero, current-fieldId %d.", fieldId), false);
        }
        return Lookup.Builder.anLookup().withClassId(calculator.getLookupEntityClassId()).withFieldId(calculator.getLookupEntityFieldId()).withRelationId(calculator.getLookupRelationId()).build();
    }

    private static AutoFill toAutoFill(long fieldId, Calculator calculator) {
        AutoFill.DomainNoType domainNoType = AutoFill.DomainNoType.instance((int)calculator.getDomainNoSenior());
        if (calculator.getLevel() < 1) {
            throw new MetaSyncClientException(String.format("[autoFill-level] could not be less than %d, fieldId [%d]", fieldId, 1), false);
        }
        switch (domainNoType) {
            case NORMAL: {
                if (!calculator.getPatten().isEmpty()) break;
                throw new MetaSyncClientException(String.format("[autoFill-patten] could not be null, fieldId [%d]", fieldId), false);
            }
            case SENIOR: {
                if (!calculator.getExpression().isEmpty()) break;
                throw new MetaSyncClientException(String.format("[autoFill-expression] could not be null, fieldId [%d]", fieldId), false);
            }
            default: {
                throw new MetaSyncClientException(String.format("[autoFill-domainNoType] should not be null, fieldId [%d]", fieldId), false);
            }
        }
        return AutoFill.Builder.anAutoFill().withModel(calculator.getModel()).withStep(calculator.getStep()).withMax(calculator.getMax()).withMin(calculator.getMin()).withLevel(calculator.getLevel()).withPatten(calculator.getPatten()).withResetType(calculator.getResetType()).withExpression(calculator.getExpression()).withArgs((List)calculator.getArgsList()).withDomainNoType(domainNoType).build();
    }

    private static Formula toFormula(FieldType fieldType, Calculator calculator) {
        if (calculator.getExpression().isEmpty()) {
            throw new MetaSyncClientException("[formula-expression] could not be null.", false);
        }
        if (calculator.getLevel() < 1) {
            throw new MetaSyncClientException(String.format("[formula-level] could not be less than %d.", 1), false);
        }
        Optional<Object> failedValueOp = Optional.empty();
        ArrayList args = new ArrayList();
        Formula.FailedPolicy policy = Formula.FailedPolicy.instance((int)calculator.getFailedPolicy());
        if (policy.equals((Object)Formula.FailedPolicy.UNKNOWN)) {
            throw new MetaSyncClientException("[calculator-failedPolicy] could not be unknown with type [formula].", false);
        }
        if (policy.equals((Object)Formula.FailedPolicy.USE_FAILED_DEFAULT_VALUE)) {
            if (!calculator.getFailedDefaultValue().isInitialized()) {
                throw new MetaSyncClientException("[calculator-failedDefaultValueCould] could not be null when policy [USE_FAILED_DEFAULT_VALUE] with type [formula].", false);
            }
            try {
                failedValueOp = EntityClassStorageBuilderUtils.toFieldTypeValue(fieldType, calculator.getFailedDefaultValue());
            }
            catch (Exception e) {
                throw new MetaSyncClientException(String.format("calculator convert failedDefaultValue failed with type [formula], message : %s", e.getMessage()), false);
            }
        }
        if (!calculator.getArgsList().isEmpty()) {
            args.addAll(calculator.getArgsList());
        }
        Formula.Builder builder = Formula.Builder.anFormula().withExpression(calculator.getExpression()).withLevel(calculator.getLevel()).withArgs(args).withFailedPolicy(policy);
        failedValueOp.ifPresent(arg_0 -> ((Formula.Builder)builder).withFailedDefaultValue(arg_0));
        return builder.build();
    }

    private static Aggregation toAggregation(Calculator calculator) {
        return Aggregation.Builder.anAggregation().withClassId(calculator.getAggregationBoId()).withFieldId(calculator.getAggregationFieldId()).withAggregationType(AggregationType.getInstance((int)calculator.getAggregationType())).withRelationId(calculator.getAggregationRelationId()).withAggregationByFields(calculator.getAggregationByFieldsMap()).withAggregationConditions(EntityClassStorageBuilderUtils.aggregationConditions(calculator.getDomainConditionsList())).build();
    }

    private static List<Aggregation.AggregationCondition> aggregationConditions(List<DomainCondition> domainConditions) {
        ArrayList<Aggregation.AggregationCondition> aggregationConditions = new ArrayList<Aggregation.AggregationCondition>();
        if (null != domainConditions) {
            for (DomainCondition domainCondition : domainConditions) {
                Aggregation.AggregationCondition aggregationCondition = Aggregation.AggregationCondition.Builder.anAggregationCondition().withEntityClassId(domainCondition.getEntityId()).withEntityClassCode(domainCondition.getEntityCode()).withEntityFieldCode(domainCondition.getEntityFieldCode()).withEntityFieldId(domainCondition.getEntityFieldId()).withProfile(domainCondition.getProfile()).withStringValue(domainCondition.getValues()).withConditionOperator(ConditionOperatorMap.instance(domainCondition.getOperator()).getConditionOperator()).withEntityFieldType(FieldType.fromRawType((String)domainCondition.getFieldType().name())).build();
                aggregationConditions.add(aggregationCondition);
            }
        }
        return aggregationConditions;
    }

    private static FieldConfig toFieldConfig(boolean isRelationEntity, FieldType fieldType, long fieldId, com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.FieldConfig fieldConfig, Calculator calculator) {
        FieldConfig.Builder builder = FieldConfig.Builder.anFieldConfig().withSearchable(fieldConfig.getSearchable()).withMax(fieldConfig.getMax()).withMin(fieldConfig.getMin()).withPrecision(fieldConfig.getPrecision()).withScale(fieldConfig.getValueFloatScale()).withIdentifie(fieldConfig.getIdentifier()).withRequired(fieldConfig.getIsRequired()).withValidateRegexString(fieldConfig.getValidateRegexString()).withSplittable(false).withDelimiter("").withDisplayType(fieldConfig.getDisplayType()).withFieldSense(FieldConfig.FieldSense.getInstance((int)fieldConfig.getMetaFieldSenseValue())).withFuzzyType(FieldConfig.FuzzyType.getInstance((int)fieldConfig.getFuzzyType())).withWildcardMinWidth(fieldConfig.getWildcardMinWidth()).withWildcardMaxWidth(fieldConfig.getWildcardMaxWidth()).withUniqueName(fieldConfig.getUniqueName()).withCrossSearch(fieldConfig.getCrossSearch()).withLen(fieldConfig.getLength()).withJdbcType(fieldConfig.getJdbcType());
        if (!isRelationEntity) {
            builder.withCalculation(EntityClassStorageBuilderUtils.toCalculator(fieldId, fieldType, calculator));
        } else {
            builder.withCalculation((AbstractCalculation)StaticCalculation.Builder.anStaticCalculation().build());
        }
        return builder.build();
    }

    private static CalculationType toCalculationType(Calculator calculator) {
        try {
            Integer type = calculator.getCalculateType();
            return CalculationType.getInstance((byte)type.byteValue());
        }
        catch (Exception e) {
            throw new MetaSyncClientException("to calculationType instance failed.", false);
        }
    }

    public static Optional<?> toFieldTypeValue(FieldType fieldType, Any any) throws Exception {
        String[] value = null;
        if (any.isInitialized()) {
            switch (fieldType) {
                case DATETIME: {
                    value = DateTimeValue.toLocalDateTime((long)((Int64Value)any.unpack(Int64Value.class)).getValue());
                    break;
                }
                case LONG: {
                    value = ((Int64Value)any.unpack(Int64Value.class)).getValue();
                    break;
                }
                case DECIMAL: {
                    value = BigDecimal.valueOf(((DoubleValue)any.unpack(DoubleValue.class)).getValue());
                    break;
                }
                case BOOLEAN: {
                    value = ((BoolValue)any.unpack(BoolValue.class)).getValue();
                    break;
                }
                case STRING: 
                case ENUM: {
                    value = ((StringValue)any.unpack(StringValue.class)).getValue();
                    break;
                }
                case STRINGS: {
                    value = StringsValue.toStrings((String)((StringValue)any.unpack(StringValue.class)).getValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("un-support type, fieldType : %s, protoTypeUrl : %s", fieldType.getType(), any.getTypeUrl()));
                }
            }
        }
        return Optional.ofNullable(value);
    }
}

