/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.conditions;

import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionOperator;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class Condition
implements Serializable {
    private IEntityClass entityClass;
    private IEntityField field;
    private IValue[] values;
    private ConditionOperator operator;
    private boolean range;

    public Condition(IEntityField field, ConditionOperator operator, IValue ... values) {
        this(null, field, operator, values);
    }

    public Condition(IEntityClass entityClass, IEntityField field, ConditionOperator operator, IValue ... values) {
        this.entityClass = entityClass;
        this.field = field;
        this.operator = operator;
        this.values = values;
        if (this.values == null || this.values.length == 0) {
            throw new IllegalArgumentException("Invalid query condition, must have at least one value.");
        }
        this.checkRange();
    }

    public Optional<IEntityClass> getEntityClass() {
        return Optional.ofNullable(this.entityClass);
    }

    public IEntityField getField() {
        return this.field;
    }

    public IValue getFirstValue() {
        return this.values[0];
    }

    public IValue[] getValues() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public ConditionOperator getOperator() {
        return this.operator;
    }

    public boolean isRange() {
        return this.range;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Condition)) {
            return false;
        }
        Condition condition = (Condition)o;
        return this.isRange() == condition.isRange() && Objects.equals(this.getEntityClass(), condition.getEntityClass()) && Objects.equals(this.getField(), condition.getField()) && Arrays.equals(this.getValues(), condition.getValues()) && this.getOperator() == condition.getOperator();
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.getEntityClass(), this.getField(), this.getOperator(), this.isRange()});
        result = 31 * result + Arrays.hashCode(this.getValues());
        return result;
    }

    public String toString() {
        String code = this.entityClass != null ? this.entityClass.code() : "";
        StringBuilder buff = new StringBuilder();
        if (code.length() > 0) {
            buff.append(code).append(".");
        }
        buff.append(this.field.name()).append(" ").append(this.getOperator().getSymbol()).append(" ");
        switch (this.getOperator()) {
            case MULTIPLE_EQUALS: {
                buff.append("(");
                int emptyLen = buff.length();
                for (IValue v : this.values) {
                    if (buff.length() > emptyLen) {
                        buff.append(", ");
                    }
                    this.appendValue(buff, v);
                }
                buff.append(")");
                break;
            }
            default: {
                this.appendValue(buff, this.getFirstValue());
            }
        }
        return buff.toString();
    }

    private void appendValue(StringBuilder buff, IValue value) {
        switch (value.getField().type()) {
            case STRING: 
            case ENUM: {
                buff.append("\"").append(value.valueToString()).append("\"");
                break;
            }
            default: {
                buff.append(value.valueToString());
            }
        }
    }

    private void checkRange() {
        switch (this.getOperator()) {
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_EQUALS: 
            case GREATER_THAN_EQUALS: {
                this.range = true;
                break;
            }
            default: {
                this.range = false;
            }
        }
    }
}

