/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldConfig;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Wrapped;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class AliasField
implements IEntityField,
Wrapped<IEntityField>,
Serializable {
    private final IEntityField originField;
    private Set<String> alias = new HashSet<String>();

    public AliasField(IEntityField originField) {
        this.originField = originField;
        this.alias.add(originField.name());
    }

    public void addName(String name) {
        this.alias.add(name);
    }

    @Override
    public long id() {
        return this.originField.id();
    }

    @Override
    public String name() {
        return String.join((CharSequence)",", this.alias);
    }

    public String firstName() {
        return this.alias.stream().findFirst().orElse("");
    }

    public String filterName(String name) {
        return this.alias.stream().filter(x -> x.equals(name)).findFirst().orElse("");
    }

    @Override
    public String cnName() {
        return this.originField.cnName();
    }

    @Override
    public FieldType type() {
        return this.originField.type();
    }

    @Override
    public FieldConfig config() {
        return this.originField.config();
    }

    @Override
    public String dictId() {
        return this.originField.dictId();
    }

    @Override
    public String defaultValue() {
        return this.originField.defaultValue();
    }

    public String toString() {
        return "AliasField{id=" + this.id() + ", alias=" + this.alias + ", originField=" + this.originField + '}';
    }

    @Override
    public IEntityField getOriginObject() {
        return this.originField;
    }
}

