/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class EntityClass
implements IEntityClass {
    private long id;
    private String name;
    private String code;
    private List<Relation> relations;
    private Set<IEntityClass> entityClasses;
    private IEntityClass extendEntityClass;
    private Collection<IEntityField> fields = Collections.emptyList();

    public EntityClass() {
    }

    public EntityClass(long id) {
        this.id = id;
    }

    public EntityClass(long id, String code, Collection<IEntityField> fields) {
        this(id, code, null, null, null, fields);
    }

    public EntityClass(long id, String code, IEntityField ... fields) {
        this(id, code, null, null, null, Arrays.asList(fields));
    }

    public EntityClass(long id, String code, Collection<Relation> relations, Collection<IEntityClass> entityClasses, IEntityClass extendEntityClass, Collection<IEntityField> fields) {
        this.id = id;
        this.code = code;
        this.relations = relations == null ? Collections.emptyList() : new ArrayList<Relation>(relations);
        this.entityClasses = entityClasses == null ? Collections.emptySet() : new HashSet<IEntityClass>(entityClasses);
        this.fields = fields == null ? Collections.emptyList() : new ArrayList<IEntityField>(fields);
        this.extendEntityClass = extendEntityClass;
    }

    public EntityClass(Long id, String code, String name, Collection<Relation> relations, Collection<IEntityClass> entityClasss, IEntityClass extendEntityClass, Collection<IEntityField> fields) {
        this((long)id, code, relations, entityClasss, extendEntityClass, fields);
        this.name = name;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Collection<Relation> relations() {
        return this.relations;
    }

    public Set<IEntityClass> entityClasss() {
        return Collections.unmodifiableSet(this.entityClasses);
    }

    @Override
    public IEntityClass extendEntityClass() {
        return this.extendEntityClass;
    }

    @Override
    public List<IEntityField> fields() {
        return new ArrayList<IEntityField>(this.fields);
    }

    @Override
    public Optional<IEntityField> field(String name) {
        return this.fields.stream().filter(f -> name.equals(f.name())).findFirst();
    }

    @Override
    public Optional<IEntityField> field(long id) {
        return this.fields.stream().filter(f -> id == f.id()).findFirst();
    }

    @Override
    public boolean isAny() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityClass)) {
            return false;
        }
        EntityClass that = (EntityClass)o;
        return this.id == that.id && Objects.equals(this.relations, that.relations) && Objects.equals(this.entityClasses, that.entityClasses) && Objects.equals(this.extendEntityClass, that.extendEntityClass) && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.relations, this.entityClasses, this.extendEntityClass, this.fields);
    }

    public String toString() {
        return "EntityClass{id=" + this.id + ", relations=" + this.relations + ", entityClasss=" + this.entityClasses + ", extendEntityClass=" + this.extendEntityClass + ", fields=" + this.fields + '}';
    }
}

