/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.reader;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldLikeRelationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.AliasField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.ColumnField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relation;
import com.xforceplus.ultraman.oqsengine.pojo.reader.FieldScope;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.GeneralRecord;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IEntityClassReader {
    private Logger logger = LoggerFactory.getLogger(IEntityClassReader.class);
    private IEntityClass entityClass;
    private Map<Long, AliasField> idMappingFieldsAll;
    private Map<String, List<ColumnField>> codedFields_self;
    private Map<String, List<ColumnField>> codedFields_related;
    private List<ColumnField> allColumn_self;
    private List<ColumnField> allColumn_related;
    private Map<Long, List<IEntityClass>> relatedEntities;
    private static final String FIELD_CODE_AMBIGUOUS = "field [{}] code is ambiguous, return first id [{}]";
    private static final String FIELD_MISSING = "[{}] is not available in EntityClass [{}]";
    private List<AliasField> allFields;

    private IEntityClassReader() {
    }

    public IEntityClassReader(IEntityClass entityClass, IEntityClass ... related) {
        this.entityClass = entityClass;
        Stream entityFields = entityClass.fields().stream();
        Stream entityParentFields = Optional.ofNullable(entityClass.extendEntityClass()).map(IEntityClass::fields).orElse(Collections.emptyList()).stream();
        Map<Boolean, List<Relation>> fieldLikeRelation = entityClass.relations().stream().filter(x -> x.getEntityField() != null).filter(x -> FieldLikeRelationType.from(x.getRelationType()).isPresent()).collect(Collectors.groupingBy(x -> FieldLikeRelationType.from(x.getRelationType()).get().isOwnerSide()));
        this.relatedEntities = entityClass.entityClasss().stream().collect(Collectors.groupingBy(IEntityClass::id));
        AtomicInteger index = new AtomicInteger(0);
        Stream fieldsInRelated = entityClass.relations().stream().flatMap(rel -> {
            IEntityClass relatedEntityClass = this.relatedEntities.get(rel.getEntityClassId()).get(0);
            Stream<ColumnField> selfStream = relatedEntityClass.fields().stream().map(field -> new ColumnField(rel.getName() + "." + field.name(), (IEntityField)field, relatedEntityClass));
            Stream<ColumnField> parentStream = Optional.ofNullable(relatedEntityClass.extendEntityClass()).map(IEntityClass::fields).orElseGet(Collections::emptyList).stream().map(field -> new ColumnField(rel.getName() + "." + field.name(), (IEntityField)field, relatedEntityClass.extendEntityClass()));
            return Stream.concat(selfStream, parentStream);
        });
        this.allColumn_self = Stream.concat(Stream.concat(entityFields, entityParentFields), Optional.ofNullable(fieldLikeRelation.get(true)).orElseGet(Collections::emptyList).stream().map(Relation::getEntityField)).map(x -> new ColumnField(x.name(), (IEntityField)x, entityClass)).distinct().peek(x -> x.setIndex(index.getAndIncrement())).collect(Collectors.toList());
        this.allColumn_related = Stream.concat(fieldsInRelated, Optional.ofNullable(fieldLikeRelation.get(false)).orElseGet(Collections::emptyList).stream().map(relation -> {
            IEntityField field = relation.getEntityField();
            return new ColumnField(field.name(), field, this.relatedEntities.get(relation.getEntityClassId()).get(0));
        })).distinct().peek(x -> x.setIndex(index.getAndIncrement())).collect(Collectors.toList());
        this.codedFields_self = this.allColumn_self.stream().collect(Collectors.groupingBy(IEntityField::name));
        this.codedFields_related = this.allColumn_related.stream().collect(Collectors.groupingBy(IEntityField::name));
        Stream allStream = Stream.concat(this.allColumn_self.stream(), this.allColumn_related.stream());
        Map<Long, List<IEntityField>> collect = allStream.collect(Collectors.groupingBy(IEntityField::id));
        this.allFields = collect.entrySet().stream().sorted(Comparator.comparingLong(Map.Entry::getKey)).map(x -> {
            AliasField field = new AliasField((IEntityField)((List)x.getValue()).get(0));
            ((List)x.getValue()).stream().map(IEntityField::name).forEach(field::addName);
            return field;
        }).collect(Collectors.toList());
        this.idMappingFieldsAll = this.allFields.stream().collect(Collectors.toMap(AliasField::id, y -> y));
    }

    public Optional<AliasField> field(long id) {
        return this.field(id, FieldScope.ALL);
    }

    public Optional<AliasField> field(long id, FieldScope scope) {
        return Optional.ofNullable(this.idMappingFieldsAll.get(id));
    }

    private boolean checkAmbiguous(List<ColumnField> candidates) {
        return candidates.stream().map(ColumnField::originField).distinct().count() > 1L;
    }

    public Optional<ColumnField> column(String code, FieldScope scope) {
        if (scope == null) {
            scope = FieldScope.ALL;
        }
        List codeSelectedField = Collections.emptyList();
        switch (scope) {
            case SELF_ONLY: {
                codeSelectedField = Optional.ofNullable(this.codedFields_self.get(code)).orElseGet(Collections::emptyList);
                break;
            }
            case RELATED_ONLY: {
                codeSelectedField = Optional.ofNullable(this.codedFields_related.get(code)).orElseGet(Collections::emptyList);
                break;
            }
            case ALL: {
                codeSelectedField = new LinkedList();
                codeSelectedField.addAll(Optional.ofNullable(this.codedFields_self.get(code)).orElseGet(Collections::emptyList));
                codeSelectedField.addAll(Optional.ofNullable(this.codedFields_related.get(code)).orElseGet(Collections::emptyList));
                break;
            }
        }
        if (!codeSelectedField.isEmpty() && this.checkAmbiguous(codeSelectedField)) {
            this.logger.error(FIELD_CODE_AMBIGUOUS, (Object)code, codeSelectedField.get(0));
        }
        return codeSelectedField.isEmpty() ? Optional.empty() : Optional.ofNullable(codeSelectedField.get(0));
    }

    public Optional<ColumnField> column(String code) {
        return this.column(code, FieldScope.ALL);
    }

    public List<ColumnField> columns() {
        ArrayList<ColumnField> list = new ArrayList<ColumnField>();
        list.addAll(this.allColumn_self);
        list.addAll(this.allColumn_related);
        return list;
    }

    public List<IEntityField> fields() {
        return this.fields(FieldScope.ALL);
    }

    public List<IEntityField> fields(FieldScope fieldScope) {
        return Collections.unmodifiableList(this.allFields);
    }

    public Set<String> testBody(Map<String, Object> map) {
        Set<String> inputKeys = map.keySet();
        HashSet<String> allKeys = new HashSet<String>();
        allKeys.addAll(this.codedFields_self.keySet());
        allKeys.addAll(this.codedFields_related.keySet());
        return inputKeys.stream().filter(x -> !allKeys.contains(x)).collect(Collectors.toSet());
    }

    public Stream<Tuple2<IEntityField, Object>> zipValue(Map<String, Object> body) {
        this.testBody(body).forEach(x -> this.logger.warn(FIELD_MISSING, x, (Object)this.entityClass.code()));
        Record record = this.toRecord(body);
        return record.stream();
    }

    public Record toRecord(Map<String, Object> body) {
        HashSet<ColumnField> columns = new HashSet<ColumnField>();
        List<ColumnField> valueColumn = body.keySet().stream().map(this::column).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        columns.addAll(valueColumn);
        columns.addAll(this.allColumn_self);
        GeneralRecord record = new GeneralRecord(columns);
        valueColumn.forEach(x -> record.set((IEntityField)x, body.get(x.name())));
        return record;
    }

    public Optional<IEntityClass> getSearchableRelatedEntity(String key) {
        return this.entityClass.relations().stream().filter(x -> FieldLikeRelationType.from(x.getRelationType()).map(FieldLikeRelationType::isOwnerSide).orElse(false)).filter(x -> key.equals(x.getName())).map(x -> this.relatedEntities.get(x.getEntityClassId()).get(0)).findFirst();
    }

    public Optional<IEntityField> getRelatedOriginalField(IEntityField entityField) {
        String fieldName = entityField.name();
        String[] fields = fieldName.split("\\.");
        if (fields.length > 1) {
            String relName = fields[0];
            return this.column(relName + ".id").map(ColumnField::originField);
        }
        return Optional.empty();
    }
}

