/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.utils;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldConfig;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.BooleanValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DateTimeValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DecimalValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.EnumValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.LongValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.StringValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.StringsValue;
import com.xforceplus.ultraman.oqsengine.pojo.utils.IEntityClassHelper;
import com.xforceplus.ultraman.oqsengine.pojo.utils.LoggerUtils;
import io.vavr.Tuple2;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IEntityFieldHelper {
    private Logger logger = LoggerFactory.getLogger(IEntityClassHelper.class);

    private List<IValue> toTypedValue(IEntityField entityField, String value) {
        try {
            Objects.requireNonNull(value, "value\u503c\u4e0d\u80fd\u4e3a\u7a7a");
            Objects.requireNonNull(entityField, "field\u503c\u4e0d\u80fd\u4e3a\u7a7a");
            LinkedList<IValue> iValues = new LinkedList<IValue>();
            switch (entityField.type()) {
                case LONG: {
                    iValues.add(new LongValue(entityField, Long.parseLong(value)));
                    break;
                }
                case DATETIME: {
                    Instant instant = Instant.ofEpochMilli(Long.parseLong(value));
                    iValues.add(new DateTimeValue(entityField, LocalDateTime.ofInstant(instant, DateTimeValue.zoneId)));
                    break;
                }
                case ENUM: {
                    iValues.add(new EnumValue(entityField, value));
                    break;
                }
                case BOOLEAN: {
                    iValues.add(new BooleanValue(entityField, Boolean.parseBoolean(value)));
                    break;
                }
                case DECIMAL: {
                    int precision = Optional.ofNullable(entityField.config()).map(FieldConfig::getPrecision).filter(x -> x > 0).orElse(1);
                    iValues.add(new DecimalValue(entityField, new BigDecimal(value).setScale(precision, RoundingMode.HALF_UP)));
                    break;
                }
                case STRINGS: {
                    iValues.add(new StringsValue(entityField, value));
                    break;
                }
                default: {
                    iValues.add(new StringValue(entityField, value));
                }
            }
            return iValues;
        }
        catch (Exception ex) {
            this.logger.error("{}", (Throwable)ex);
            throw new RuntimeException(LoggerUtils.typeConverterError(entityField, value, ex));
        }
    }

    private List<IValue> toTypedValue(IEntityClass entityClass, Long id, String value) {
        try {
            Objects.requireNonNull(value, "\u503c\u4e0d\u80fd\u4e3a\u7a7a");
            Optional<Tuple2<IEntityClass, IEntityField>> fieldTuple = IEntityClassHelper.findFieldByIdInAll(entityClass, id);
            Optional<IEntityField> fieldOp = fieldTuple.map(Tuple2::_2);
            if (entityClass.extendEntityClass() != null && !fieldOp.isPresent()) {
                fieldOp = entityClass.extendEntityClass().field(id);
            }
            if (fieldOp.isPresent()) {
                return this.toTypedValue(fieldOp.get(), value);
            }
            this.logger.error("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684field id:{}", (Object)id);
            return null;
        }
        catch (Exception ex) {
            this.logger.error("{}", (Throwable)ex);
            throw new RuntimeException("\u7c7b\u578b\u8f6c\u6362\u5931\u8d25 " + ex.getMessage());
        }
    }
}

