/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.entity;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldConfig;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.BooleanValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DateTimeValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DecimalValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.EnumValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.LongValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.StringValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.StringsValue;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;

public enum FieldType {
    UNKNOWN("Unknown", s -> false, StringValue::new),
    BOOLEAN("Boolean", s -> {
        try {
            Boolean.parseBoolean(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }, new String[]{"boolean"}, (f, v) -> new BooleanValue((IEntityField)f, Boolean.parseBoolean(v))),
    ENUM("Enum", new String[]{"enum"}, EnumValue::new),
    DATETIME("DateTime", s -> {
        try {
            Instant.ofEpochMilli(Long.parseLong(s));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }, new String[]{"timestamp"}, (f, v) -> {
        Instant instant = Instant.ofEpochMilli(Long.parseLong(v));
        return new DateTimeValue((IEntityField)f, LocalDateTime.ofInstant(instant, DateTimeValue.zoneId));
    }),
    LONG("Long", s -> {
        try {
            Long.parseLong(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }, new String[]{"bigint", "long", "serialNo"}, (f, v) -> new LongValue((IEntityField)f, Long.parseLong(v))),
    STRING("String", new String[]{"string"}, StringValue::new),
    STRINGS("Strings", new String[]{"strings"}, (x$0, xva$1) -> new StringsValue((IEntityField)x$0, (String)xva$1)),
    DECIMAL("Decimal", s -> {
        try {
            new BigDecimal((String)s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }, new String[]{"double", "decimal"}, (f, v) -> {
        int precision = Optional.ofNullable(f.config()).map(FieldConfig::getPrecision).filter(x -> x > 0).orElse(2);
        return new DecimalValue((IEntityField)f, new BigDecimal((String)v).setScale(precision, RoundingMode.HALF_UP));
    });

    private String type;
    private Predicate<String> tester;
    private String[] accepts;
    private BiFunction<IEntityField, String, IValue> iValueConverter;

    private FieldType(String type, Predicate<String> tester, String[] accepts, BiFunction<IEntityField, String, IValue> iValueConverter) {
        this.type = type;
        this.tester = tester;
        this.accepts = accepts;
        this.iValueConverter = iValueConverter;
    }

    private FieldType(String type, Predicate<String> tester, BiFunction<IEntityField, String, IValue> iValueConverter) {
        this(type, tester, new String[0], iValueConverter);
    }

    private FieldType(String type, String[] accepts, BiFunction<IEntityField, String, IValue> iValueConverter) {
        this(type, s -> true, accepts, iValueConverter);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean canParseFrom(String input) {
        return this.tester.test(input);
    }

    public Optional<IValue> toTypedValue(IEntityField entityField, String value) {
        Objects.requireNonNull(value, "value\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        Objects.requireNonNull(entityField, "field\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.tester.test(value)) {
            return Optional.ofNullable(this.iValueConverter.apply(entityField, value));
        }
        return Optional.empty();
    }

    public boolean accept(String rawType) {
        return Stream.of(this.accepts).anyMatch(x -> x.equalsIgnoreCase(rawType));
    }

    public static FieldType fromRawType(String rawType) {
        try {
            return FieldType.valueOf(rawType.toUpperCase());
        }
        catch (Exception exception) {
            return Stream.of(FieldType.values()).filter(x -> x.accept(rawType)).findFirst().orElse(STRING);
        }
    }
}

