/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.reader.record;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralRecord
implements Record {
    private Logger log = LoggerFactory.getLogger(GeneralRecord.class);
    private final Object[] values;
    private final IEntityField[] fields;
    private final Boolean isEmpty;
    private Long id;

    public static Record empty() {
        return new GeneralRecord();
    }

    private GeneralRecord() {
        this.isEmpty = true;
        this.values = null;
        this.fields = null;
    }

    public GeneralRecord(Collection<? extends IEntityField> fields) {
        int size = fields.size();
        this.fields = new IEntityField[fields.size()];
        this.values = new Object[size];
        int i = 0;
        Iterator<? extends IEntityField> iterator = fields.iterator();
        while (iterator.hasNext()) {
            IEntityField field;
            this.fields[i] = field = iterator.next();
            ++i;
        }
        this.isEmpty = false;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Optional<Object> get(String fieldName) {
        return this.field(fieldName).flatMap(this::get);
    }

    @Override
    public Object get(int index) {
        if (index >= this.values.length) {
            this.log.error("OutOfBound exception for visit index:{} and return null!", (Object)index);
            return null;
        }
        return this.values[index];
    }

    private Optional<IEntityField> field(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        IEntityField fieldMatch = null;
        for (IEntityField f : this.fields) {
            if (!fieldName.equals(f.name())) continue;
            if (fieldMatch == null) {
                fieldMatch = f;
                continue;
            }
            this.log.info("Ambiguous match found for " + fieldName + ". Both " + fieldMatch + " and " + f + " match.");
        }
        return Optional.ofNullable(fieldMatch);
    }

    private final int indexOf(IEntityField field) {
        if (field != null) {
            int i;
            int size = this.fields.length;
            for (i = 0; i < size; ++i) {
                if (this.fields[i] != field) continue;
                return i;
            }
            for (i = 0; i < size; ++i) {
                if (!this.fields[i].equals(field)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Optional<Object> get(IEntityField field) {
        int index = this.indexOf(field);
        if (index > -1 && index < this.values.length) {
            return Optional.ofNullable(this.values[index]);
        }
        return Optional.empty();
    }

    @Override
    public Optional<IValue> getTypedValue(String fieldName) {
        return this.field(fieldName).flatMap(this::getTypedValue);
    }

    @Override
    public Optional<IValue> getTypedValue(IEntityField field) {
        return this.get(field).flatMap(x -> field.type().toTypedValue(field, x.toString()));
    }

    @Override
    public <T> Optional<T> get(String fieldName, Class<? extends T> type) {
        return this.field(fieldName).flatMap(this::get).map(x -> x);
    }

    @Override
    public <T> Optional<T> get(IEntityField field, Class<? extends T> type) {
        return this.get(field).map(x -> x);
    }

    @Override
    public void set(String fieldName, Object t) {
        this.field(fieldName).ifPresent(x -> this.set((IEntityField)x, t));
    }

    @Override
    public void set(IEntityField field, Object t) {
        int index = this.indexOf(field);
        if (index > -1 && index < this.values.length) {
            this.values[index] = t;
        } else {
            this.log.warn("{} is not present", (Object)field.name());
        }
    }

    @Override
    public void fromMap(Map<String, Object> map) {
        map.forEach(this::set);
    }

    @Override
    public void setTypedValue(IValue iValue) {
        if (iValue != null && iValue.getValue() != null && iValue.getField() != null) {
            this.set(iValue.getField(), iValue.getValue());
        }
    }

    @Override
    public Stream<Tuple2<IEntityField, Object>> stream() {
        return IntStream.range(0, this.fields.length).mapToObj(i -> Tuple.of((Object)this.fields[i], (Object)this.values[i]));
    }

    @Override
    public Stream<Tuple2<IEntityField, Object>> stream(Set<String> filterName) {
        return IntStream.range(0, this.fields.length).mapToObj(i -> {
            String name = this.fields[i].name();
            if (filterName != null && !filterName.isEmpty()) {
                if (filterName.contains(name)) {
                    return Tuple.of((Object)this.fields[i], (Object)this.values[i]);
                }
                return null;
            }
            return Tuple.of((Object)this.fields[i], (Object)this.values[i]);
        }).filter(Objects::nonNull);
    }

    @Override
    public Map<String, Object> toMap(Set<String> filterName) {
        HashMap<String, Object> map = new HashMap<String, Object>(this.values.length);
        IntStream.range(0, this.values.length).forEach(i -> {
            String name = this.fields[i].name();
            if (filterName != null && !filterName.isEmpty()) {
                if (filterName.contains(name)) {
                    map.put(name, this.values[i]);
                }
            } else {
                map.put(name, this.values[i]);
            }
        });
        return map;
    }

    @Override
    public Map<String, Object> toNestedMap(Set<String> filterName) {
        HashMap<String, Object> map = new HashMap<String, Object>(this.values.length);
        IntStream.range(0, this.values.length).forEach(i -> {
            String name = this.fields[i].name();
            Boolean insert = false;
            if (filterName != null && !filterName.isEmpty()) {
                if (filterName.contains(name)) {
                    insert = true;
                }
            } else {
                insert = true;
            }
            if (insert.booleanValue()) {
                if (name.contains(".")) {
                    String[] names = name.split("\\.");
                    HashMap<String, Object> currentMap = map;
                    for (int index = 0; index < names.length - 1; ++index) {
                        String seg = names[index];
                        Object segMap = currentMap.get(seg);
                        if (segMap == null) {
                            HashMap<String, Object> innerMap = new HashMap<String, Object>();
                            currentMap.put(seg, innerMap);
                            currentMap = innerMap;
                            continue;
                        }
                        if (!(segMap instanceof Map)) continue;
                        currentMap = (Map)segMap;
                    }
                    currentMap.put(names[names.length - 1], this.values[i]);
                } else {
                    map.put(name, this.values[i]);
                }
            }
        });
        return map;
    }

    @Override
    public Boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public Boolean nonEmpty() {
        return this.isEmpty == false;
    }

    @Override
    public int compareTo(Record record) {
        return 0;
    }
}

