/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.conditions;

import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.LinkConditionNode;
import java.io.Serializable;
import java.util.ArrayDeque;

public abstract class AbstractConditionNode
implements Serializable {
    private AbstractConditionNode left;
    private AbstractConditionNode right;
    private boolean closed;
    private boolean red;

    public AbstractConditionNode(AbstractConditionNode left, AbstractConditionNode right) {
        this.left = left;
        this.right = right;
        this.closed = false;
        this.red = false;
        this.setRed(this.findRed(left));
        if (!this.isRed()) {
            this.setRed(this.findRed(right));
        }
    }

    public boolean hasLeft() {
        return this.getLeft() != null;
    }

    public boolean hasRight() {
        return this.getRight() != null;
    }

    public AbstractConditionNode getLeft() {
        return this.left;
    }

    public AbstractConditionNode getRight() {
        return this.right;
    }

    protected void setLeft(AbstractConditionNode left) {
        this.left = left;
        if (!this.isRed()) {
            this.setRed(this.findRed(this.left));
        }
    }

    protected void setRight(AbstractConditionNode right) {
        this.right = right;
        if (!this.isRed()) {
            this.setRed(this.findRed(this.right));
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isRed() {
        return this.red;
    }

    public void setRed(boolean red) {
        this.red = red;
    }

    public abstract String toString();

    public abstract String toPrefixExpression();

    private boolean findRed(AbstractConditionNode node) {
        if (node == null) {
            return false;
        }
        ArrayDeque<AbstractConditionNode> stack = new ArrayDeque<AbstractConditionNode>();
        stack.push(node);
        while (!stack.isEmpty()) {
            AbstractConditionNode point = (AbstractConditionNode)stack.pop();
            if (point.isRed()) {
                return true;
            }
            if (!LinkConditionNode.class.isInstance(point)) continue;
            if (point.getLeft() != null) {
                stack.push(point.getLeft());
            }
            if (point.getRight() == null) continue;
            stack.push(point.getRight());
        }
        return false;
    }
}

