/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.conditions;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Entity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DateTimeValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DecimalValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.LongValue;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public enum ConditionOperator {
    UNKNOWN("UNKNOWN", (field, values) -> entity -> false),
    LIKE("LIKE", (field, values) -> {
        if (((IValue[])values).length > 0) {
            return entity -> {
                IEntityValue entityValue = entity.entityValue();
                Optional<IValue> valueOp = entityValue.getValue(field.id());
                if (valueOp.isPresent()) {
                    IValue targetValue = valueOp.get();
                    return targetValue.valueToString().contains(values[0].valueToString());
                }
                return false;
            };
        }
        throw new RuntimeException("err invalid");
    }),
    EQUALS("=", (field, values) -> {
        if (((IValue[])values).length > 0) {
            return entity -> {
                IEntityValue entityValue = entity.entityValue();
                Optional<IValue> valueOp = entityValue.getValue(field.id());
                if (valueOp.isPresent()) {
                    IValue targetValue = valueOp.get();
                    return targetValue.getValue().equals(values[0].getValue());
                }
                return false;
            };
        }
        throw new RuntimeException("err invalid");
    }),
    NOT_EQUALS("!=", (field, values) -> {
        if (((IValue[])values).length > 0) {
            return entity -> {
                IEntityValue entityValue = entity.entityValue();
                Optional<IValue> valueOp = entityValue.getValue(field.id());
                if (valueOp.isPresent()) {
                    IValue targetValue = valueOp.get();
                    return !targetValue.getValue().equals(values[0].getValue());
                }
                return false;
            };
        }
        throw new RuntimeException("err invalid");
    }),
    GREATER_THAN(">", (field, values) -> {
        if (((IValue[])values).length > 0) {
            return entity -> {
                IEntityValue entityValue = entity.entityValue();
                Optional<IValue> valueOp = entityValue.getValue(field.id());
                return valueOp.filter(left -> ConditionOperator.numberValueCompare(left, values[0], i -> i > 0)).isPresent();
            };
        }
        throw new RuntimeException("err invalid");
    }),
    GREATER_THAN_EQUALS(">=", (field, values) -> {
        if (((IValue[])values).length > 0) {
            return entity -> {
                IEntityValue entityValue = entity.entityValue();
                Optional<IValue> valueOp = entityValue.getValue(field.id());
                return valueOp.filter(left -> ConditionOperator.numberValueCompare(left, values[0], i -> i >= 0)).isPresent();
            };
        }
        throw new RuntimeException("err invalid");
    }),
    LESS_THAN("<", (field, values) -> {
        if (((IValue[])values).length > 0) {
            return entity -> {
                IEntityValue entityValue = entity.entityValue();
                Optional<IValue> valueOp = entityValue.getValue(field.id());
                return valueOp.filter(left -> ConditionOperator.numberValueCompare(left, values[0], i -> i < 0)).isPresent();
            };
        }
        throw new RuntimeException("err invalid");
    }),
    LESS_THAN_EQUALS("<=", (field, values) -> {
        if (((IValue[])values).length > 0) {
            return entity -> {
                IEntityValue entityValue = entity.entityValue();
                Optional<IValue> valueOp = entityValue.getValue(field.id());
                return valueOp.filter(left -> ConditionOperator.numberValueCompare(left, values[0], i -> i <= 0)).isPresent();
            };
        }
        throw new RuntimeException("err invalid");
    }),
    MULTIPLE_EQUALS("IN", (field, values) -> entity -> {
        IEntityValue entityValue = entity.entityValue();
        Optional<IValue> valueOp = entityValue.getValue(field.id());
        return valueOp.filter(left -> Arrays.stream(values).anyMatch(x -> x.getValue().equals(left.getValue()))).isPresent();
    }),
    IS_NULL("ISNULL", (field, values) -> entity -> {
        IEntityValue entityValue = entity.entityValue();
        Optional<IValue> valueOp = entityValue.getValue(field.id());
        return !valueOp.isPresent();
    }),
    IS_NOT_NULL("ISNOTNULL", (field, values) -> entity -> {
        IEntityValue entityValue = entity.entityValue();
        Optional<IValue> valueOp = entityValue.getValue(field.id());
        return valueOp.isPresent();
    });

    private String symbol;
    private BiFunction<IEntityField, IValue[], Predicate<Entity>> predicateFunction;

    private ConditionOperator(String symbol, BiFunction<IEntityField, IValue[], Predicate<Entity>> predicateFunction) {
        this.symbol = symbol;
        this.predicateFunction = predicateFunction;
    }

    public String getSymbol() {
        return this.symbol;
    }

    private static boolean numberValueCompare(IValue<?> left, IValue<?> right, Predicate<Integer> compareResult) {
        if (left instanceof LongValue && right instanceof LongValue) {
            Long leftVal = (Long)((LongValue)left).getValue();
            Long rightVal = (Long)((LongValue)right).getValue();
            return compareResult.test(leftVal.compareTo(rightVal));
        }
        if (left instanceof DateTimeValue && right instanceof DateTimeValue) {
            Long leftVal = left.valueToLong();
            Long rightVal = right.valueToLong();
            return compareResult.test(leftVal.compareTo(rightVal));
        }
        if (left instanceof DecimalValue && right instanceof DecimalValue) {
            BigDecimal leftVal = (BigDecimal)((DecimalValue)left).getValue();
            BigDecimal rightVal = (BigDecimal)((DecimalValue)right).getValue();
            return compareResult.test(leftVal.compareTo(rightVal));
        }
        return false;
    }

    public Predicate<Entity> getPredicate(IEntityField entityField, IValue[] values) {
        return this.predicateFunction.apply(entityField, values);
    }

    public static ConditionOperator getInstance(String symbol) {
        String noSpaceSymbol = symbol.trim();
        for (ConditionOperator operator : ConditionOperator.values()) {
            if (!operator.getSymbol().equals(noSpaceSymbol)) continue;
            return operator;
        }
        return null;
    }
}

