/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.entity;

public enum CalculationType {
    UNKNOWN(0),
    STATIC(1),
    FORMULA(2, 2, true, true, false),
    AUTO_FILL(3, 2, true, false, false),
    LOOKUP(4, 1, true, true, false),
    AGGREGATION(5, 1, true, false, false);

    private int symbol;
    private int priority;
    private boolean buildNeedNotChange;
    private boolean replaceNeedNotChange;
    private boolean deleteNeedNotChange;

    private CalculationType(int symbol) {
        this(symbol, 0, false, false, false);
    }

    private CalculationType(int symbol, int priority) {
        this(symbol, priority, false, false, false);
    }

    private CalculationType(int symbol, int priority, boolean buildNeedNotChange, boolean replaceNeedNotChange, boolean deleteNeedNotChange) {
        this.symbol = symbol;
        this.priority = priority;
        this.buildNeedNotChange = buildNeedNotChange;
        this.replaceNeedNotChange = replaceNeedNotChange;
        this.deleteNeedNotChange = deleteNeedNotChange;
    }

    public int getSymbol() {
        return this.symbol;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isBuildNeedNotChange() {
        return this.buildNeedNotChange;
    }

    public boolean isReplaceNeedNotChange() {
        return this.replaceNeedNotChange;
    }

    public boolean isDeleteNeedNotChange() {
        return this.deleteNeedNotChange;
    }

    public static CalculationType getInstance(byte symbol) {
        for (CalculationType type : CalculationType.values()) {
            if (type.getSymbol() != symbol) continue;
            return type;
        }
        return UNKNOWN;
    }
}

