/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Relationship {
    private long id;
    private String code;
    private long leftEntityClassId;
    private String leftEntityClassCode;
    private long rightEntityClassId;
    private RelationType relationType;
    private boolean identity;
    private IEntityField entityField;
    private boolean belongToOwner;
    private boolean strong;
    private BiFunction<Long, String, Optional<IEntityClass>> rightEntityClassLoader;
    private Function<Long, Collection<IEntityClass>> familyEntityClassLoader;
    private boolean companion;
    private long companionRelation;

    public IEntityClass getRightEntityClass(String profile) {
        Optional<IEntityClass> entityClassOp = this.rightEntityClassLoader.apply(this.rightEntityClassId, profile);
        return entityClassOp.orElse(null);
    }

    public Collection<IEntityClass> getRightFamilyEntityClasses() {
        return this.familyEntityClassLoader.apply(this.rightEntityClassId);
    }

    public long getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public long getLeftEntityClassId() {
        return this.leftEntityClassId;
    }

    public String getLeftEntityClassCode() {
        return this.leftEntityClassCode;
    }

    public long getRightEntityClassId() {
        return this.rightEntityClassId;
    }

    public RelationType getRelationType() {
        return this.relationType;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public IEntityField getEntityField() {
        return this.entityField;
    }

    public boolean isBelongToOwner() {
        return this.belongToOwner;
    }

    public boolean isSelfRelation(long entityClassId) {
        return entityClassId == this.leftEntityClassId && this.belongToOwner;
    }

    public boolean isStrong() {
        return this.strong;
    }

    public void setBelongToOwner(boolean belongToOwner) {
        this.belongToOwner = belongToOwner;
    }

    public boolean isCompanion() {
        return this.companion;
    }

    public void setCompanion(boolean companion) {
        this.companion = companion;
    }

    public long getCompanionRelation() {
        return this.companionRelation;
    }

    public void setCompanionRelation(long companionRelation) {
        this.companionRelation = companionRelation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Relationship that = (Relationship)o;
        return this.id == that.id && Objects.equals(this.code, that.code);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.code);
    }

    public static final class Builder {
        private long id;
        private String code;
        private long leftEntityClassId;
        private String leftEntityClassCode;
        private long rightEntityClassId;
        private RelationType relationType = RelationType.UNKNOWN;
        private boolean identity = true;
        private IEntityField entityField;
        private boolean belongToOwner = false;
        private boolean strong = false;
        private BiFunction<Long, String, Optional<IEntityClass>> entityClassLoader;
        private Function<Long, Collection<IEntityClass>> familyEntityClassLoader;
        private boolean companion = false;
        private long companionRelation;

        private Builder() {
        }

        public static Builder anRelationship() {
            return new Builder();
        }

        public Builder withId(long id) {
            this.id = id;
            return this;
        }

        public Builder withCode(String code) {
            this.code = code;
            return this;
        }

        public Builder withLeftEntityClassId(long leftEntityClassId) {
            this.leftEntityClassId = leftEntityClassId;
            return this;
        }

        public Builder withLeftEntityClassCode(String leftEntityClassCode) {
            this.leftEntityClassCode = leftEntityClassCode;
            return this;
        }

        public Builder withRightEntityClassId(long rightEntityClassId) {
            this.rightEntityClassId = rightEntityClassId;
            return this;
        }

        public Builder withRelationType(RelationType relationType) {
            this.relationType = relationType;
            return this;
        }

        public Builder withIdentity(boolean identity) {
            this.identity = identity;
            return this;
        }

        public Builder withEntityField(IEntityField entityField) {
            this.entityField = entityField;
            return this;
        }

        public Builder withBelongToOwner(boolean belongToOwner) {
            this.belongToOwner = belongToOwner;
            return this;
        }

        public Builder withCompanion(boolean isCompanion) {
            this.companion = isCompanion;
            return this;
        }

        public Builder withCompanionRelation(long relationId) {
            this.companionRelation = relationId;
            return this;
        }

        public Builder withStrong(boolean strong) {
            this.strong = strong;
            return this;
        }

        public Builder withRightEntityClassLoader(BiFunction<Long, String, Optional<IEntityClass>> entityClassLoader) {
            this.entityClassLoader = entityClassLoader;
            return this;
        }

        public Builder withRightFamilyEntityClassLoader(Function<Long, Collection<IEntityClass>> familyEntityClassLoader) {
            this.familyEntityClassLoader = familyEntityClassLoader;
            return this;
        }

        public Relationship build() {
            Relationship relationship = new Relationship();
            relationship.belongToOwner = this.belongToOwner;
            relationship.relationType = this.relationType;
            relationship.id = this.id;
            relationship.code = this.code;
            relationship.leftEntityClassId = this.leftEntityClassId;
            relationship.rightEntityClassId = this.rightEntityClassId;
            relationship.identity = this.identity;
            relationship.rightEntityClassLoader = this.entityClassLoader;
            relationship.entityField = this.entityField;
            relationship.leftEntityClassCode = this.leftEntityClassCode;
            relationship.strong = this.strong;
            relationship.companion = this.companion;
            relationship.companionRelation = this.companionRelation;
            relationship.familyEntityClassLoader = this.familyEntityClassLoader;
            return relationship;
        }
    }

    public static enum RelationType {
        UNKNOWN(0),
        ONE_TO_ONE(1),
        ONE_TO_MANY(2),
        MANY_TO_ONE(3),
        MANY_TO_MANY(4),
        MULTI_VALUES(5);

        private int value;

        private RelationType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static RelationType getInstance(int value) {
            for (RelationType t : RelationType.values()) {
                if (t.getValue() != value) continue;
                return t;
            }
            return UNKNOWN;
        }
    }
}

