/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.AggregationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.AbstractCalculation;
import java.util.Map;
import java.util.StringJoiner;

public class Aggregation
extends AbstractCalculation {
    @JsonProperty(value="classId")
    private long classId;
    @JsonProperty(value="fieldId")
    private long fieldId;
    @JsonProperty(value="relationId")
    private long relationId;
    @JsonProperty(value="conditions")
    private Conditions conditions;
    @JsonProperty(value="aggregationType")
    private AggregationType aggregationType = AggregationType.UNKNOWN;
    @JsonProperty(value="condition")
    private Map<Long, Long> aggregationByFields;

    public Aggregation(CalculationType calculationType) {
        super(calculationType);
    }

    public Aggregation() {
        super(CalculationType.AGGREGATION);
    }

    public long getClassId() {
        return this.classId;
    }

    public void setClassId(long classId) {
        this.classId = classId;
    }

    public long getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(long fieldId) {
        this.fieldId = fieldId;
    }

    public long getRelationId() {
        return this.relationId;
    }

    public void setRelationId(long relationId) {
        this.relationId = relationId;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public Map<Long, Long> getAggregationByFields() {
        return this.aggregationByFields;
    }

    public void setAggregationByFields(Map<Long, Long> aggregationByFields) {
        this.aggregationByFields = aggregationByFields;
    }

    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public String toString() {
        return new StringJoiner(", ", Aggregation.class.getSimpleName() + "[", "]").add("classId=" + this.classId).add("fieldId=" + this.fieldId).add("relationId=" + this.relationId).add("conditions=" + this.conditions).add("aggregationType=" + (Object)((Object)this.aggregationType)).add("aggregationByFields=" + this.aggregationByFields).toString();
    }

    @Override
    public AbstractCalculation clone() {
        Aggregation aggregation = new Aggregation();
        aggregation.classId = this.classId;
        aggregation.fieldId = this.fieldId;
        aggregation.level = this.level;
        aggregation.aggregationByFields = this.aggregationByFields;
        aggregation.conditions = this.conditions;
        aggregation.relationId = this.relationId;
        aggregation.aggregationType = this.aggregationType;
        return aggregation;
    }

    public static final class Builder {
        private long classId;
        private long fieldId;
        private long relationId;
        private Conditions conditions;
        private AggregationType aggregationType;
        private Map<Long, Long> aggregationByFields;

        private Builder() {
        }

        public static Builder anAggregation() {
            return new Builder();
        }

        public Builder withFieldId(long fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public Builder withClassId(long classId) {
            this.classId = classId;
            return this;
        }

        public Builder withRelationId(long relationId) {
            this.relationId = relationId;
            return this;
        }

        public Builder withConditions(Conditions conditions) {
            this.conditions = conditions;
            return this;
        }

        public Builder withAggregationType(AggregationType aggregationType) {
            this.aggregationType = aggregationType;
            return this;
        }

        public Builder withAggregationByFields(Map<Long, Long> aggregationByFields) {
            this.aggregationByFields = aggregationByFields;
            return this;
        }

        public Aggregation build() {
            Aggregation aggregation = new Aggregation();
            aggregation.calculationType = CalculationType.AGGREGATION;
            aggregation.classId = this.classId;
            aggregation.fieldId = this.fieldId;
            aggregation.level = 1;
            aggregation.aggregationByFields = this.aggregationByFields;
            aggregation.conditions = this.conditions;
            aggregation.relationId = this.relationId;
            aggregation.aggregationType = this.aggregationType;
            return aggregation;
        }
    }
}

