/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.AbstractCalculation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.Formula;
import java.util.List;
import java.util.StringJoiner;

public class AutoFill
extends AbstractCalculation {
    @JsonProperty(value="patten")
    private String patten;
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="step")
    private int step;
    @JsonProperty(value="min")
    private String min;
    @JsonProperty(value="max")
    private String max;
    @JsonProperty(value="code")
    protected String code;
    @JsonProperty(value="expression")
    private String expression;
    @JsonProperty(value="args")
    private List<String> args;
    @JsonProperty(value="domainNoSenior")
    private DomainNoType domainNoType;
    @JsonProperty(value="resetType")
    private int resetType;

    public String getPatten() {
        return this.patten;
    }

    public void setPatten(String patten) {
        this.patten = patten;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public String getMin() {
        return this.min;
    }

    public void setMin(String min) {
        this.min = min;
    }

    public String getMax() {
        return this.max;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    public DomainNoType getDomainNoType() {
        return this.domainNoType;
    }

    public void setDomainNoType(DomainNoType domainNoType) {
        this.domainNoType = domainNoType;
    }

    public int getResetType() {
        return this.resetType;
    }

    public void setResetType(int resetType) {
        this.resetType = resetType;
    }

    private AutoFill() {
        super(CalculationType.AUTO_FILL);
    }

    @Override
    public AbstractCalculation clone() {
        AutoFill autoFill = new AutoFill();
        autoFill.step = this.step;
        autoFill.model = this.model;
        autoFill.patten = this.patten;
        autoFill.max = this.max;
        autoFill.min = this.min;
        autoFill.code = this.code;
        autoFill.expression = this.expression;
        autoFill.level = this.level;
        autoFill.args = this.args;
        autoFill.domainNoType = this.domainNoType;
        autoFill.resetType = this.resetType;
        return autoFill;
    }

    public String toString() {
        return new StringJoiner(", ", AutoFill.class.getSimpleName() + "[", "]").add("patten='" + this.patten + "'").add("model='" + this.model + "'").add("step=" + this.step).add("min='" + this.min + "'").add("max='" + this.max + "'").add("code='" + this.code + "'").add("expression='" + this.expression + "'").add("args=" + this.args).add("domainNoType=" + (Object)((Object)this.domainNoType)).add("resetType=" + this.resetType).toString();
    }

    public static enum DomainNoType {
        UNKNOWN(0),
        NORMAL(1),
        SENIOR(2);

        private int type;

        private DomainNoType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public static DomainNoType instance(int type) {
            for (DomainNoType domainNoType : DomainNoType.values()) {
                if (domainNoType.getType() != type) continue;
                return domainNoType;
            }
            return UNKNOWN;
        }
    }

    public static final class Builder {
        private String patten;
        private String model;
        private int step;
        private String min;
        private String max;
        private String expression;
        private int level;
        private List<String> args;
        private DomainNoType domainNoType;
        private int resetType;

        private Builder() {
        }

        public static Builder anAutoFill() {
            return new Builder();
        }

        public Builder withPatten(String patten) {
            this.patten = patten;
            return this;
        }

        public Builder withModel(String model) {
            this.model = model;
            return this;
        }

        public Builder withStep(int step) {
            this.step = step;
            return this;
        }

        public Builder withMin(String min) {
            this.min = min;
            return this;
        }

        public Builder withMax(String max) {
            this.max = max;
            return this;
        }

        public Builder withExpression(String expression) {
            this.expression = expression;
            return this;
        }

        public Builder withLevel(int level) {
            this.level = level;
            return this;
        }

        public Builder withArgs(List<String> args) {
            this.args = args;
            return this;
        }

        public Builder withDomainNoType(DomainNoType domainNoType) {
            this.domainNoType = domainNoType;
            return this;
        }

        public Builder withResetType(int resetType) {
            this.resetType = resetType;
            return this;
        }

        public AutoFill build() {
            AutoFill autoFill = new AutoFill();
            autoFill.calculationType = CalculationType.AUTO_FILL;
            autoFill.patten = this.patten;
            autoFill.model = this.model;
            autoFill.step = this.step;
            autoFill.min = this.min;
            autoFill.max = this.max;
            if (null != this.expression && !this.expression.isEmpty()) {
                autoFill.expression = this.expression;
                autoFill.code = Formula.codeGenerate(this.expression);
            }
            autoFill.level = this.level;
            autoFill.args = this.args;
            if (null == this.domainNoType) {
                this.domainNoType = DomainNoType.NORMAL;
            }
            autoFill.domainNoType = this.domainNoType;
            autoFill.resetType = this.resetType;
            return autoFill;
        }
    }
}

