/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.values;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.AbstractValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import java.math.BigDecimal;

public class DecimalValue
extends AbstractValue<BigDecimal> {
    public DecimalValue(IEntityField field, BigDecimal value) {
        this(field, value, (String)null);
    }

    public DecimalValue(IEntityField field, BigDecimal value, String attachment) {
        super(field, DecimalValue.buildWellBigDecimal(field, value), attachment);
    }

    @Override
    BigDecimal fromString(String value) {
        if (value != null) {
            return DecimalValue.buildWellBigDecimal(this.getField(), new BigDecimal(value));
        }
        return null;
    }

    @Override
    public long valueToLong() {
        return ((BigDecimal)this.getValue()).longValue();
    }

    @Override
    protected IValue<BigDecimal> doCopy(IEntityField newField, String attachment) {
        return new DecimalValue(newField, (BigDecimal)this.getValue(), attachment);
    }

    @Override
    public String valueToString() {
        return ((BigDecimal)this.getValue()).toPlainString();
    }

    private static BigDecimal buildWellBigDecimal(IEntityField field, BigDecimal value) {
        BigDecimal wellValue;
        String plainValue = value.toPlainString();
        String[] checkValues = plainValue.split("\\.");
        Long.parseLong(checkValues[0]);
        if (checkValues.length > 1) {
            Long.parseLong(checkValues[1]);
        }
        if (plainValue.indexOf(".") < 0) {
            plainValue = value.longValue() + ".0";
            wellValue = new BigDecimal(plainValue);
        } else {
            wellValue = value;
        }
        return wellValue;
    }
}

