/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.values;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.AbstractValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import java.util.Arrays;
import java.util.Objects;

public class StringsValue
extends AbstractValue<String[]> {
    private static final String DELIMITER = ",";

    public StringsValue(IEntityField field, String ... value) {
        super(field, value);
    }

    public StringsValue(IEntityField field, String[] value, String attachment) {
        super(field, value, attachment);
    }

    @Override
    String[] fromString(String value) {
        return value == null ? null : value.split(DELIMITER);
    }

    @Override
    public long valueToLong() {
        throw new UnsupportedOperationException("A string cannot be represented by a number.");
    }

    @Override
    public String valueToString() {
        return String.join((CharSequence)DELIMITER, (CharSequence[])this.getValue());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringsValue)) {
            return false;
        }
        String[] thatValues = (String[])((StringsValue)o).getValue();
        if (thatValues.length != ((String[])this.getValue()).length) {
            return false;
        }
        if (Objects.equals(this.getAttachment(), ((StringsValue)o).getAttachment())) {
            return true;
        }
        for (String v : (String[])this.getValue()) {
            boolean found = true;
            for (String tv : thatValues) {
                if (!tv.equals(v)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getField(), this.getValue());
    }

    @Override
    public String toString() {
        return "StringValue{field=" + this.getField() + ", value=" + Arrays.toString((Object[])this.getValue()) + '}';
    }

    @Override
    protected IValue<String[]> doCopy(IEntityField newField, String attachment) {
        return new StringsValue(newField, (String[])this.getValue(), attachment);
    }

    public static String[] toStrings(String stringValues) {
        return stringValues.split(DELIMITER);
    }
}

