/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.page;

import com.xforceplus.ultraman.oqsengine.pojo.page.PageScope;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Page
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = -6034178522810109360L;
    private static final long UNSET = -1L;
    private static final long DEFAULT_PAGE_SIZE = 10L;
    private static final long DEFAULT_PAGE_INDEX = 1L;
    private boolean singlePage = false;
    private boolean emptyPage = false;
    private long pageSize;
    private long pageIndex;
    private long totalCount = -1L;
    private long surplusCount;
    private long pageCount;
    private boolean ready = false;
    private boolean lastPage = false;
    private long visibleTotalCount = -1L;

    public Page() {
        this(1L, 10L);
    }

    public Page(long pageIndex, long pageSize) {
        this.pageIndex = pageIndex > 0L ? pageIndex : 1L;
        this.pageSize = pageSize > 0L ? pageSize : 10L;
    }

    public static Page emptyPage() {
        long fixOne = 1L;
        Page page = new Page(1L, 1L);
        page.emptyPage = true;
        return page;
    }

    public static Page newSinglePage(long pageSize) {
        Page page = new Page(1L, pageSize);
        page.singlePage = true;
        page.setTotalCount(pageSize);
        return page;
    }

    public static Page lastPage(long pageSize) {
        Page page = new Page(0L, pageSize);
        page.lastPage = true;
        return page;
    }

    public long getIndex() {
        return this.pageIndex;
    }

    public long getPageCount() {
        if (this.ready) {
            if (this.isEmptyPage()) {
                return 0L;
            }
            return this.pageCount;
        }
        return 0L;
    }

    public Page setVisibleTotalCount(long totalCount) {
        if (totalCount <= 0L) {
            throw new IllegalArgumentException("The total amount of data must be a positive integer greater than 0.");
        }
        this.visibleTotalCount = totalCount;
        return this;
    }

    public long getVisibleTotalCount() {
        return this.visibleTotalCount;
    }

    public boolean hasVisibleTotalCountLimit() {
        return this.visibleTotalCount != -1L;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
        if (!this.isEmptyPage()) {
            long useTotalCount = this.totalCount;
            if (this.visibleTotalCount != -1L && this.totalCount > this.visibleTotalCount) {
                useTotalCount = this.visibleTotalCount;
            }
            this.pageCount = this.countPageCount(this.getPageSize(), useTotalCount);
            if (this.lastPage) {
                this.pageIndex = this.pageCount;
            }
            this.surplusCount = this.countSurplus(this.pageIndex, this.getPageSize(), totalCount);
        }
        this.ready = true;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public PageScope getNextPage() {
        this.checkReady();
        if (!this.hasNextPage()) {
            return null;
        }
        long startLine = this.getIndex() * this.getPageSize() - (this.getPageSize() - 1L);
        this.surplusCount = this.countSurplus(this.pageIndex, this.getPageSize(), this.totalCount);
        long endLine = this.surplusCount <= this.getPageSize() ? startLine + (this.surplusCount - 1L) : startLine + (this.getPageSize() - 1L);
        ++this.pageIndex;
        if (startLine < 0L) {
            startLine = 0L;
        }
        if (endLine < 0L) {
            endLine = 0L;
        }
        return new PageScope(startLine, endLine);
    }

    public PageScope getAppointPage(long appointPageIndex) {
        this.checkReady();
        if (this.isEmptyPage()) {
            return new PageScope(0L, 0L);
        }
        long nowPointIndex = appointPageIndex;
        if (nowPointIndex <= 0L) {
            return null;
        }
        if (nowPointIndex > this.pageCount) {
            return null;
        }
        long startLine = nowPointIndex * this.getPageSize() - (this.getPageSize() - 1L);
        this.surplusCount = this.countSurplus(nowPointIndex, this.getPageSize(), this.totalCount);
        long endLine = this.surplusCount <= this.getPageSize() ? startLine + (this.surplusCount - 1L) : startLine + (this.getPageSize() - 1L);
        return new PageScope(startLine, endLine);
    }

    public boolean hasNextPage() {
        this.checkReady();
        if (this.isEmptyPage()) {
            return false;
        }
        return this.pageIndex <= this.pageCount;
    }

    public boolean isReady() {
        return this.ready;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.getClass());
        if (this.isReady()) {
            buff.append("[");
            buff.append("PageSize=");
            buff.append(this.getPageSize());
            buff.append(",");
            buff.append("PageIndex=");
            buff.append(this.getIndex());
            buff.append(",");
            buff.append("PageCount=");
            buff.append(this.getPageCount());
            buff.append(",");
            buff.append("TotalNumber=");
            buff.append(this.getTotalCount());
            buff.append("]");
        } else {
            buff.append(" can not work.");
        }
        return buff.toString();
    }

    public Page clone() throws CloneNotSupportedException {
        return (Page)super.clone();
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.singlePage ? 1 : 0);
        hash = 89 * hash + (int)(this.pageSize ^ this.pageSize >>> 32);
        hash = 89 * hash + (int)(this.pageIndex ^ this.pageIndex >>> 32);
        hash = 89 * hash + (int)(this.totalCount ^ this.totalCount >>> 32);
        hash = 89 * hash + (int)(this.surplusCount ^ this.surplusCount >>> 32);
        hash = 89 * hash + (int)(this.pageCount ^ this.pageCount >>> 32);
        hash = 89 * hash + (this.ready ? 1 : 0);
        hash = 89 * hash + (this.lastPage ? 1 : 0);
        hash = 89 * hash + (this.emptyPage ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Page other = (Page)obj;
        if (this.isEmptyPage() != other.isEmptyPage()) {
            return false;
        }
        if (this.isSinglePage() != other.isSinglePage()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        return this.isReady() == other.isReady();
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public boolean isSinglePage() {
        return this.singlePage;
    }

    public boolean isEmptyPage() {
        return this.emptyPage;
    }

    protected long countPageCount(long pageNumber, long totalNumber) {
        return totalNumber / pageNumber + (long)(totalNumber % pageNumber == 0L ? 0 : 1);
    }

    protected long countSurplus(long indexNumber, long sizeNumber, long totalNumber) {
        return totalNumber - sizeNumber * (indexNumber - 1L);
    }

    private void checkReady() {
        if (!this.ready) {
            throw new IllegalStateException("Have not designated data amount!");
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.singlePage);
        out.writeLong(this.pageSize);
        out.writeLong(this.pageIndex);
        out.writeLong(this.totalCount);
        out.writeLong(this.surplusCount);
        out.writeLong(this.pageCount);
        out.writeBoolean(this.ready);
        out.writeBoolean(this.lastPage);
        out.writeBoolean(this.emptyPage);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.singlePage = in.readBoolean();
        this.pageSize = in.readLong();
        this.pageIndex = in.readLong();
        this.totalCount = in.readLong();
        this.surplusCount = in.readLong();
        this.pageCount = in.readLong();
        this.ready = in.readBoolean();
        this.lastPage = in.readBoolean();
        this.emptyPage = in.readBoolean();
    }
}

