/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.cdc.metrics;

import com.alibaba.fastjson.JSON;
import com.xforceplus.ultraman.oqsengine.pojo.cdc.metrics.CDCMetrics;
import com.xforceplus.ultraman.oqsengine.pojo.cdc.metrics.CDCUnCommitMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDCMetricsRecorder {
    final Logger logger = LoggerFactory.getLogger(CDCMetricsRecorder.class);
    private CDCMetrics cdcMetrics;
    private long start;

    public CDCMetricsRecorder startRecord(CDCUnCommitMetrics cdcUnCommitMetrics, long batchId) {
        this.start = System.currentTimeMillis();
        this.cdcMetrics = new CDCMetrics();
        this.cdcMetrics.setBatchId(batchId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[cdc-metrics-record] start consume batch, batchId : {}", (Object)batchId);
        }
        if (null != cdcUnCommitMetrics) {
            this.cdcMetrics.getCdcUnCommitMetrics().setUnCommitIds(cdcUnCommitMetrics.getUnCommitIds());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[cdc-metrics-record] current batch : {} have last batch un-commit ids : {}", (Object)batchId, JSON.toJSON(this.cdcMetrics.getCdcUnCommitMetrics().getUnCommitIds()));
            }
        }
        return this;
    }

    public CDCMetricsRecorder finishRecord(int syncCount) {
        this.cdcMetrics.getCdcAckMetrics().setExecuteRows(syncCount);
        this.cdcMetrics.getCdcAckMetrics().setTotalUseTime(System.currentTimeMillis() - this.start);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[cdc-metrics-record] finish consume batch, batchId : {}, success sync rows : {}, totalUseTime : {}", new Object[]{this.cdcMetrics.getBatchId(), this.cdcMetrics.getCdcAckMetrics().getExecuteRows(), this.cdcMetrics.getCdcAckMetrics().getTotalUseTime()});
        }
        return this;
    }

    public CDCMetrics getCdcMetrics() {
        return this.cdcMetrics;
    }
}

