/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.conditions;

import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.AbstractConditionNode;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionLink;
import java.io.Serializable;
import java.util.Objects;

public class LinkConditionNode
extends AbstractConditionNode
implements Serializable {
    private ConditionLink link;
    private boolean shadow;
    private LinkConditionNode actual;

    public LinkConditionNode(AbstractConditionNode l, AbstractConditionNode r, ConditionLink link) {
        super(l, r);
        this.link = link;
        this.shadow = false;
    }

    public LinkConditionNode buildShadow() {
        if (!this.shadow) {
            LinkConditionNode shadowNode = new LinkConditionNode(this.getLeft(), this.getRight(), this.getLink());
            shadowNode.shadow = true;
            shadowNode.actual = this;
            shadowNode.setRed(this.isRed());
            return shadowNode;
        }
        return this;
    }

    public LinkConditionNode getActual() {
        if (this.isShadow()) {
            return this.actual;
        }
        return this;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public ConditionLink getLink() {
        return this.link;
    }

    @Override
    public String toString() {
        StringBuilder buff = new StringBuilder();
        if (this.isClosed()) {
            buff.append("(");
        }
        buff.append(this.getLeft().toString()).append(" ").append(this.link.toString()).append(" ").append(this.getRight().toString());
        if (this.isClosed()) {
            buff.append(")");
        }
        return buff.toString();
    }

    @Override
    public String toPrefixExpression() {
        StringBuilder buff = new StringBuilder();
        if (this.isClosed()) {
            buff.append("(");
        }
        buff.append(this.link.toString()).append(this.isRed() ? "(r)" : "").append(" ").append(this.getLeft().toPrefixExpression()).append(" ").append(this.getRight().toPrefixExpression());
        if (this.isClosed()) {
            buff.append(")");
        }
        return buff.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LinkConditionNode)) {
            return false;
        }
        LinkConditionNode other = (LinkConditionNode)o;
        if (this.link != other.link) {
            return false;
        }
        AbstractConditionNode left = this.getLeft();
        AbstractConditionNode otherLeft = other.getLeft();
        if (left == null && otherLeft != null || left != null && otherLeft == null) {
            return false;
        }
        if (!left.equals(otherLeft)) {
            return false;
        }
        AbstractConditionNode right = this.getRight();
        AbstractConditionNode othetRight = other.getRight();
        if (right == null && othetRight != null || right != null && othetRight == null) {
            return false;
        }
        return right.equals(othetRight);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getLink()});
    }
}

