/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.values.verifier;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldConfig;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.EmptyTypedValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.verifier.VerifierResult;

public interface ValueVerifier {
    default public VerifierResult verify(IEntityField field, IValue value) {
        if (!this.isRequired(field, value)) {
            return VerifierResult.REQUIRED;
        }
        if (value != null && !EmptyTypedValue.class.isInstance(value)) {
            if (!this.isTooLong(field, value)) {
                return VerifierResult.TOO_LONG;
            }
            if (!this.isHighPrecision(field, value)) {
                return VerifierResult.HIGH_PRECISION;
            }
        }
        return VerifierResult.OK;
    }

    default public boolean isRequired(IEntityField field, IValue value) {
        FieldConfig config = field.config();
        return !config.isRequired() || value != null && !EmptyTypedValue.class.isInstance(value);
    }

    default public boolean isTooLong(IEntityField field, IValue value) {
        return true;
    }

    default public boolean isHighPrecision(IEntityField field, IValue value) {
        return true;
    }
}

