/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.query;

import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Condition;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionLink;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionOperator;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.LinkConditionNode;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ParentheseConditionNode;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ValueConditionNode;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Entity;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MemQuery {
    public static Collection<IEntity> query(Collection<IEntity> entities, Conditions conditions) {
        PredicateHolder holder = new PredicateHolder();
        conditions.scan(holder::accept, holder::accept, holder::accept);
        Predicate<IEntity> predicate = holder.getPredicate();
        return Optional.ofNullable(entities).orElseGet(Collections::emptyList).stream().filter(predicate).collect(Collectors.toList());
    }

    static class PredicateHolder {
        private Deque<Object> stack = new LinkedList<Object>();

        PredicateHolder() {
        }

        void accept(LinkConditionNode linkConditionNode) {
            this.stack.push((Object)linkConditionNode.getLink());
        }

        void accept(ValueConditionNode valueConditionNode) {
            Object peek;
            Predicate<Entity> next = this.toPredicate(valueConditionNode);
            if (!this.stack.isEmpty() && (peek = this.stack.peek()) != null && peek instanceof ConditionLink) {
                ConditionLink linkNode = (ConditionLink)((Object)peek);
                this.stack.pop();
                Object nextPeek = this.stack.peek();
                if (nextPeek instanceof Predicate) {
                    this.stack.pop();
                    if (linkNode.equals((Object)ConditionLink.AND)) {
                        Predicate<Entity> and = ((Predicate)nextPeek).and(next);
                        next = and;
                    } else if (linkNode.equals((Object)ConditionLink.OR)) {
                        Predicate<Entity> or = ((Predicate)nextPeek).or(next);
                        next = or;
                    }
                }
            }
            this.stack.push(next);
        }

        void accept(ParentheseConditionNode parentheseConditionNode) {
            if (parentheseConditionNode.isLeft()) {
                this.stack.push(parentheseConditionNode);
            } else if (parentheseConditionNode.isRight()) {
                Object pop;
                Predicate unWrapper = null;
                while (this.stack.size() > 0 && !((pop = this.stack.pop()) instanceof ParentheseConditionNode)) {
                    if (!(pop instanceof Predicate)) continue;
                    unWrapper = (Predicate)pop;
                }
                if (unWrapper != null) {
                    this.stack.push(unWrapper);
                }
            }
        }

        private Predicate<Entity> toPredicate(ValueConditionNode node) {
            Condition condition = node.getCondition();
            IEntityField field = condition.getField();
            ConditionOperator operator = condition.getOperator();
            Predicate<Entity> predicate = operator.getPredicate(field, condition.getValues());
            return predicate;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Predicate<IEntity> getPredicate() {
            while (this.stack.size() > 1) {
                Object expectedPredicateNext;
                Object expectedPredicate = this.stack.pop();
                Predicate next = null;
                if (!(expectedPredicate instanceof Predicate)) throw new RuntimeException("Syntax error");
                if (this.stack.isEmpty()) {
                    return (Predicate)expectedPredicate;
                }
                Object expectedLinkOrNull = this.stack.peek();
                if (!(expectedLinkOrNull instanceof ConditionLink)) throw new RuntimeException("Syntax error");
                Object link = this.stack.pop();
                if (!this.stack.isEmpty() && (expectedPredicateNext = this.stack.peek()) instanceof Predicate) {
                    this.stack.pop();
                    if (link.equals((Object)ConditionLink.AND)) {
                        Predicate and;
                        next = and = ((Predicate)expectedPredicate).and((Predicate)expectedPredicateNext);
                    } else if (link.equals((Object)ConditionLink.OR)) {
                        Predicate or = ((Predicate)expectedPredicate).or((Predicate)expectedPredicateNext);
                        next = or;
                    }
                }
                if (next == null) continue;
                this.stack.push(next);
            }
            return (Predicate)this.stack.pop();
        }
    }
}

