/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.cdc.metrics;

import com.xforceplus.ultraman.oqsengine.pojo.cdc.enums.CDCStatus;
import com.xforceplus.ultraman.oqsengine.pojo.cdc.metrics.CDCAckMetrics;
import com.xforceplus.ultraman.oqsengine.pojo.cdc.metrics.CDCUnCommitMetrics;

public class CDCMetrics {
    private long batchId;
    private CDCAckMetrics cdcAckMetrics;
    private CDCUnCommitMetrics cdcUnCommitMetrics;

    public CDCMetrics() {
        this(-1L, new CDCAckMetrics(CDCStatus.CONNECTED), new CDCUnCommitMetrics());
        this.cdcAckMetrics.setLastConnectedTime(System.currentTimeMillis());
    }

    public CDCMetrics(long batchId, CDCAckMetrics cdcAckMetrics, CDCUnCommitMetrics cdcUnCommitMetrics) {
        this.batchId = batchId;
        this.cdcAckMetrics = cdcAckMetrics;
        this.cdcUnCommitMetrics = cdcUnCommitMetrics;
    }

    public long getBatchId() {
        return this.batchId;
    }

    public void setBatchId(long batchId) {
        this.batchId = batchId;
    }

    public CDCAckMetrics getCdcAckMetrics() {
        return this.cdcAckMetrics;
    }

    public void setCdcAckMetrics(CDCAckMetrics cdcAckMetrics) {
        this.cdcAckMetrics = cdcAckMetrics;
    }

    public CDCUnCommitMetrics getCdcUnCommitMetrics() {
        return this.cdcUnCommitMetrics;
    }

    public void connected() {
        this.cdcAckMetrics.setLastConnectedTime(System.currentTimeMillis());
        this.cdcAckMetrics.setCdcConsumerStatus(CDCStatus.CONNECTED);
    }

    public void setCdcUnCommitMetrics(CDCUnCommitMetrics cdcUnCommitMetrics) {
        this.cdcUnCommitMetrics = cdcUnCommitMetrics;
    }

    public void syncFreeMessage(long batchId) {
        this.batchId = batchId;
        this.cdcAckMetrics.setExecuteRows(0);
    }

    public void consumeSuccess(long originBatchId, CDCMetrics temp, boolean isConnectSync) {
        this.cdcUnCommitMetrics = temp.getCdcUnCommitMetrics();
        this.batchId = originBatchId;
        this.cdcAckMetrics.setCdcConsumerStatus(CDCStatus.CONNECTED);
        if (!isConnectSync) {
            this.cdcAckMetrics.setLastConsumerTime(System.currentTimeMillis());
        } else {
            this.cdcAckMetrics.setLastConnectedTime(System.currentTimeMillis());
        }
        if (!temp.getCdcAckMetrics().getCommitList().isEmpty()) {
            this.cdcAckMetrics.setCommitList(temp.getCdcAckMetrics().getCommitList());
        }
        this.cdcAckMetrics.setExecuteRows(temp.getCdcAckMetrics().getExecuteRows());
        this.cdcAckMetrics.setTotalUseTime(temp.getCdcAckMetrics().getTotalUseTime());
    }

    public void error(CDCStatus cdcStatus) {
        this.cdcAckMetrics.setCdcConsumerStatus(cdcStatus);
    }
}

