/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public final class EntityRef
implements Serializable,
Comparable<EntityRef> {
    private long id;
    private int op;
    private int major;
    private String orderValue;
    private String secondOrderValue;
    private String thridOrderValue;

    public long getId() {
        return this.id;
    }

    public int getOp() {
        return this.op;
    }

    public int getMajor() {
        return this.major;
    }

    public Optional<String> getSortValue(int index) {
        switch (index) {
            case 0: {
                return Optional.ofNullable(this.getOrderValue());
            }
            case 1: {
                return Optional.ofNullable(this.getSecondOrderValue());
            }
            case 2: {
                return Optional.ofNullable(this.getThridOrderValue());
            }
        }
        return Optional.empty();
    }

    public String getOrderValue() {
        return this.orderValue;
    }

    public String getSecondOrderValue() {
        return this.secondOrderValue;
    }

    public String getThridOrderValue() {
        return this.thridOrderValue;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setOp(int op) {
        this.op = op;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public void setOrderValue(String orderValue) {
        this.orderValue = orderValue;
    }

    public void setSecondOrderValue(String secondOrderValue) {
        this.secondOrderValue = secondOrderValue;
    }

    public void setThridOrderValue(String thridOrderValue) {
        this.thridOrderValue = thridOrderValue;
    }

    public void setSortValue(int index, String sortValue) {
        switch (index) {
            case 0: {
                this.setOrderValue(sortValue);
                break;
            }
            case 1: {
                this.setSecondOrderValue(sortValue);
                break;
            }
            case 2: {
                this.setThridOrderValue(sortValue);
                break;
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityRef)) {
            return false;
        }
        EntityRef entityRef = (EntityRef)o;
        return this.getId() == entityRef.getId() && this.getOp() == entityRef.getOp() && this.getMajor() == entityRef.getMajor() && Objects.equals(this.getOrderValue(), entityRef.getOrderValue());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getOp(), this.getMajor(), this.getOrderValue());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("EntityRef{");
        sb.append("id=").append(this.id);
        sb.append(", op=").append(this.op);
        sb.append(", major=").append(this.major);
        sb.append(", orderValue='").append(this.orderValue).append('\'');
        sb.append(", secondOrderValue='").append(this.secondOrderValue).append('\'');
        sb.append(", thridOrderValue='").append(this.thridOrderValue).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int compareTo(EntityRef o) {
        if (this.id < o.id) {
            return -1;
        }
        if (this.id > o.id) {
            return 1;
        }
        return 0;
    }

    public static final class Builder {
        private long id;
        private int op;
        private int major;
        private String orderValue;
        private String secondOrderValue;
        private String thridOrderValue;

        private Builder() {
        }

        public static Builder anEntityRef() {
            return new Builder();
        }

        public Builder withId(long id) {
            this.id = id;
            return this;
        }

        public Builder withOp(int op) {
            this.op = op;
            return this;
        }

        public Builder withMajor(int major) {
            this.major = major;
            return this;
        }

        public Builder withOrderValue(String orderValue) {
            this.orderValue = orderValue;
            return this;
        }

        public Builder withSecondOrderValue(String secondOrderValue) {
            this.secondOrderValue = secondOrderValue;
            return this;
        }

        public Builder withThridOrderValue(String thridOrderValue) {
            this.thridOrderValue = thridOrderValue;
            return this;
        }

        public Builder withSortValue(int index, String orderValue) {
            switch (index) {
                case 0: {
                    return this.withOrderValue(orderValue);
                }
                case 1: {
                    return this.withSecondOrderValue(orderValue);
                }
                case 2: {
                    return this.withThridOrderValue(orderValue);
                }
            }
            return this;
        }

        public EntityRef build() {
            EntityRef entityRef = new EntityRef();
            entityRef.op = this.op;
            entityRef.thridOrderValue = this.thridOrderValue;
            entityRef.id = this.id;
            entityRef.major = this.major;
            entityRef.orderValue = this.orderValue;
            entityRef.secondOrderValue = this.secondOrderValue;
            return entityRef;
        }
    }
}

