/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.conditions;

import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.AbstractConditionNode;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Condition;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionLink;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionOperator;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.LinkConditionNode;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ParentheseConditionNode;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ValueConditionNode;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.validation.ConditionValidation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.validation.fieldtype.ConditionOperatorFieldValidationFactory;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.validation.operation.ConditionOperationValidationFactory;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Entity;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Conditions
implements Serializable {
    private int size;
    private boolean or;
    private boolean range;
    private boolean fuzzy;
    private AbstractConditionNode head;

    public static Conditions buildEmtpyConditions() {
        return new Conditions();
    }

    private Conditions() {
        this.size = 0;
        this.range = false;
        this.or = false;
    }

    public Conditions(Condition condition) {
        this.validate(condition);
        this.head = new ValueConditionNode(condition);
        this.range = condition.isRange();
        this.fuzzy = condition.getOperator() == ConditionOperator.LIKE;
        this.size = 1;
    }

    public Conditions(AbstractConditionNode head) {
        this.head = head;
        Collection<Condition> conditionCollection = this.collectCondition();
        this.size = conditionCollection.size();
        this.range = conditionCollection.stream().mapToInt(c -> c.isRange() ? 1 : 0).sum() > 0;
        this.fuzzy = conditionCollection.stream().mapToInt(c -> c.getOperator() == ConditionOperator.LIKE ? 1 : 0).sum() > 0;
    }

    public Conditions addAnd(Condition condition) {
        return this.doAdd(ConditionLink.AND, condition);
    }

    public Conditions addAnd(Conditions conditions, boolean close) {
        return this.doAdd(ConditionLink.AND, conditions, close);
    }

    public Conditions addOr(Condition condition) {
        return this.doAdd(ConditionLink.OR, condition);
    }

    public Conditions addOr(Conditions conditions, boolean close) {
        return this.doAdd(ConditionLink.OR, conditions, close);
    }

    public Collection<IEntity> match(Collection<IEntity> entities) {
        if (entities == null || entities.isEmpty() || this.isEmtpy()) {
            return Collections.emptyList();
        }
        PredicateHolder holder = new PredicateHolder();
        this.scan(holder::accept, holder::accept, holder::accept);
        Predicate predicate = holder.getPredicate();
        return Optional.ofNullable(entities).orElseGet(Collections::emptyList).stream().filter(predicate).collect(Collectors.toList());
    }

    public boolean match(IEntity entity) {
        if (entity == null || this.isEmtpy()) {
            return false;
        }
        PredicateHolder holder = new PredicateHolder();
        this.scan(holder::accept, holder::accept, holder::accept);
        Predicate predicate = holder.getPredicate();
        return predicate.test(entity);
    }

    public boolean haveOrLink() {
        return this.or;
    }

    public boolean haveRangeCondition() {
        return this.range;
    }

    public boolean haveFuzzyCondition() {
        return this.fuzzy;
    }

    public void scan(Consumer<LinkConditionNode> linkAction, Consumer<ValueConditionNode> valueAction, Consumer<ParentheseConditionNode> parentheseAction) {
        this.iterTree(c -> true, c -> {
            if (Conditions.isLinkNode(c)) {
                linkAction.accept((LinkConditionNode)c);
            }
            if (Conditions.isValueNode(c)) {
                valueAction.accept((ValueConditionNode)c);
            }
            if (Conditions.isParentheseNode(c)) {
                parentheseAction.accept((ParentheseConditionNode)c);
            }
        }, false);
    }

    public Collection<AbstractConditionNode> collect() {
        LinkedList<AbstractConditionNode> nodes = new LinkedList<AbstractConditionNode>();
        this.iterTree(c -> true, c -> nodes.add((AbstractConditionNode)c), false);
        return nodes;
    }

    public Collection<Condition> collectCondition() {
        LinkedList<Condition> conditionList = new LinkedList<Condition>();
        this.iterTree(c -> Conditions.isValueNode(c), c -> conditionList.add(((ValueConditionNode)c).getCondition()), false);
        return conditionList;
    }

    public Collection<IEntityField> collectField() {
        return this.collectCondition().stream().map(c -> c.getField()).distinct().collect(Collectors.toList());
    }

    public Collection<AbstractConditionNode> collectSubTree(Predicate<? super AbstractConditionNode> predicate, boolean brake) {
        ArrayList<AbstractConditionNode> nodes = new ArrayList<AbstractConditionNode>(this.size);
        this.iterTree(predicate, c -> nodes.add((AbstractConditionNode)c), brake);
        return nodes;
    }

    public AbstractConditionNode collectConditionTree() {
        return this.head;
    }

    public Conditions close() {
        if (this.head != null) {
            this.head.setClosed(true);
        }
        return this;
    }

    public String toString() {
        if (this.size() > 0) {
            return this.head.toString();
        }
        return "Null condition.";
    }

    public String toPrefixExpression() {
        return this.head.toPrefixExpression();
    }

    public int size() {
        return this.size;
    }

    public boolean isEmtpy() {
        return this.size == 0;
    }

    public static boolean isValueNode(AbstractConditionNode node) {
        return node instanceof ValueConditionNode;
    }

    public static boolean isParentheseNode(AbstractConditionNode node) {
        return node instanceof ParentheseConditionNode;
    }

    public static boolean isLinkNode(AbstractConditionNode node) {
        return node instanceof LinkConditionNode;
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            return true;
        }
        if (!(o instanceof Conditions)) {
            return false;
        }
        Conditions that = (Conditions)o;
        boolean bl = result = this.size == that.size && this.or == that.or && this.range == that.range;
        if (result) {
            return Objects.equals(o.toString(), that.toString());
        }
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.size, this.or, this.range, this.size > 0 ? this.head.toString() : "");
    }

    private void validate(Condition condition) {
        ConditionValidation validation = ConditionOperatorFieldValidationFactory.getValidation(condition.getField().type());
        if (!validation.validate(condition)) {
            throw new IllegalArgumentException(String.format("Wrong conditions.[%s]", condition));
        }
        validation = ConditionOperationValidationFactory.getValidation(condition.getOperator());
        if (!validation.validate(condition)) {
            throw new IllegalArgumentException(String.format("Wrong conditions.[%s]", condition));
        }
    }

    private Conditions doAdd(ConditionLink link, Condition condition) {
        this.validate(condition);
        ValueConditionNode newValueNode = new ValueConditionNode(condition);
        this.doAddNode(newValueNode, link, false);
        ++this.size;
        if (link == ConditionLink.OR) {
            this.or = true;
        }
        if (!this.range) {
            this.range = condition.isRange();
        }
        if (!this.fuzzy) {
            this.fuzzy = condition.getOperator() == ConditionOperator.LIKE;
        }
        return this;
    }

    private Conditions doAdd(ConditionLink link, Conditions conditions, boolean close) {
        this.doAddNode(conditions.head, link, close);
        if (ConditionLink.OR == link && this.size > 0) {
            this.or = true;
        } else if (!this.or) {
            this.or = conditions.haveOrLink();
        }
        if (!this.range) {
            this.range = conditions.haveRangeCondition();
        }
        if (!this.fuzzy) {
            this.fuzzy = conditions.haveFuzzyCondition();
        }
        this.size += conditions.size();
        return this;
    }

    private void doAddNode(AbstractConditionNode newNode, ConditionLink link, boolean close) {
        if (this.size == 0) {
            this.head = newNode;
        } else {
            boolean onlyOneCondition = true;
            if (this.size == 1) {
                LinkConditionNode newLinkNode = new LinkConditionNode(this.head, newNode, link);
                if (ConditionLink.OR == link) {
                    newLinkNode.setRed(true);
                }
                newLinkNode.setClosed(close);
                this.head = newLinkNode;
            } else {
                LinkConditionNode linkHead = (LinkConditionNode)this.head;
                if (!linkHead.isClosed() && linkHead.getLink() == ConditionLink.OR && ConditionLink.AND == link) {
                    LinkConditionNode newLinkNode = new LinkConditionNode(linkHead.getRight(), newNode, ConditionLink.AND);
                    linkHead.setRight(newLinkNode);
                    linkHead.setClosed(close);
                } else {
                    if (close) {
                        this.head.setClosed(true);
                    }
                    LinkConditionNode newLinkNode = new LinkConditionNode(this.head, newNode, link);
                    this.head = newLinkNode;
                }
            }
        }
    }

    private void iterTree(Predicate<? super AbstractConditionNode> predicate, Consumer<? super AbstractConditionNode> consumer, boolean brake) {
        if (this.head == null) {
            return;
        }
        ArrayDeque<AbstractConditionNode> stack = new ArrayDeque<AbstractConditionNode>(this.size());
        stack.push(this.head);
        while (!stack.isEmpty()) {
            AbstractConditionNode node = (AbstractConditionNode)stack.pop();
            if (Conditions.isLinkNode(node)) {
                LinkConditionNode linkNode = (LinkConditionNode)node;
                if (linkNode.isShadow()) {
                    if (!predicate.test(linkNode.getActual())) continue;
                    consumer.accept(linkNode.getActual());
                    if (!brake) continue;
                    break;
                }
                if (predicate.test(linkNode) && brake) {
                    stack.push(linkNode.buildShadow());
                    continue;
                }
                if (linkNode.isClosed()) {
                    stack.push(ParentheseConditionNode.buildRight());
                }
                if (linkNode.hasRight()) {
                    stack.push(linkNode.getRight());
                }
                stack.push(linkNode.buildShadow());
                if (linkNode.hasLeft()) {
                    stack.push(linkNode.getLeft());
                }
                if (!linkNode.isClosed()) continue;
                stack.push(ParentheseConditionNode.buildLeft());
                continue;
            }
            if (!predicate.test(node)) continue;
            consumer.accept(node);
        }
    }

    private static class PredicateHolder {
        private Deque<Object> stack = new LinkedList<Object>();

        private PredicateHolder() {
        }

        public void accept(LinkConditionNode linkConditionNode) {
            this.stack.push((Object)linkConditionNode.getLink());
        }

        public void accept(ValueConditionNode valueConditionNode) {
            Object peek;
            Predicate<Entity> next = this.toPredicate(valueConditionNode);
            if (!this.stack.isEmpty() && (peek = this.stack.peek()) != null && peek instanceof ConditionLink) {
                ConditionLink linkNode = (ConditionLink)((Object)peek);
                this.stack.pop();
                Object nextPeek = this.stack.peek();
                if (nextPeek instanceof Predicate) {
                    this.stack.pop();
                    if (linkNode.equals((Object)ConditionLink.AND)) {
                        Predicate<Entity> and = ((Predicate)nextPeek).and(next);
                        next = and;
                    } else if (linkNode.equals((Object)ConditionLink.OR)) {
                        Predicate<Entity> or = ((Predicate)nextPeek).or(next);
                        next = or;
                    }
                }
            }
            this.stack.push(next);
        }

        public void accept(ParentheseConditionNode parentheseConditionNode) {
            if (parentheseConditionNode.isLeft()) {
                this.stack.push(parentheseConditionNode);
            } else if (parentheseConditionNode.isRight()) {
                Object pop;
                Predicate unWrapper = null;
                while (this.stack.size() > 0 && !((pop = this.stack.pop()) instanceof ParentheseConditionNode)) {
                    if (!(pop instanceof Predicate)) continue;
                    unWrapper = (Predicate)pop;
                }
                if (unWrapper != null) {
                    this.stack.push(unWrapper);
                }
            }
        }

        private Predicate<Entity> toPredicate(ValueConditionNode node) {
            Condition condition = node.getCondition();
            IEntityField field = condition.getField();
            ConditionOperator operator = condition.getOperator();
            Predicate<Entity> predicate = operator.getPredicate(field, condition.getValues());
            return predicate;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Predicate<IEntity> getPredicate() {
            while (this.stack.size() > 1) {
                Object expectedPredicateNext;
                Object expectedPredicate = this.stack.pop();
                Predicate next = null;
                if (!(expectedPredicate instanceof Predicate)) throw new RuntimeException("Syntax error");
                if (this.stack.isEmpty()) {
                    return (Predicate)expectedPredicate;
                }
                Object expectedLinkOrNull = this.stack.peek();
                if (!(expectedLinkOrNull instanceof ConditionLink)) throw new RuntimeException("Syntax error");
                Object link = this.stack.pop();
                if (!this.stack.isEmpty() && (expectedPredicateNext = this.stack.peek()) instanceof Predicate) {
                    this.stack.pop();
                    if (link.equals((Object)ConditionLink.AND)) {
                        Predicate and;
                        next = and = ((Predicate)expectedPredicate).and((Predicate)expectedPredicateNext);
                    } else if (link.equals((Object)ConditionLink.OR)) {
                        Predicate or = ((Predicate)expectedPredicate).or((Predicate)expectedPredicateNext);
                        next = or;
                    }
                }
                if (next == null) continue;
                this.stack.push(next);
            }
            return (Predicate)this.stack.pop();
        }
    }
}

