/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.entity;

import java.io.Serializable;
import java.util.Objects;

public class EntityClassRef
implements Serializable,
Comparable<EntityClassRef> {
    private long id;
    private String code;
    private String profile;

    public EntityClassRef(long id, String code) {
        this(id, code, "");
    }

    public EntityClassRef(long id, String code, String profile) {
        this.id = id;
        this.code = code;
        this.profile = profile == null || profile.isEmpty() ? "" : profile;
    }

    public long getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getProfile() {
        return this.profile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityClassRef)) {
            return false;
        }
        EntityClassRef that = (EntityClassRef)o;
        return this.getId() == that.getId() && Objects.equals(this.profile, that.profile);
    }

    public boolean equalsCompatible(EntityClassRef other) {
        return this.getId() == other.getId();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.code, this.profile);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EntityClassRef{");
        sb.append("code='").append(this.code).append('\'');
        sb.append(", id=").append(this.id);
        sb.append(", profile='").append(this.profile == null ? "NULL" : this.profile).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int compareTo(EntityClassRef o) {
        return Long.compare(this.id, o.id);
    }

    public static final class Builder {
        private long entityClassId;
        private String entityClassCode;
        private String profile;

        private Builder() {
        }

        public static Builder anEntityClassRef() {
            return new Builder();
        }

        public Builder withEntityClassId(long entityClassId) {
            this.entityClassId = entityClassId;
            return this;
        }

        public Builder withEntityClassCode(String entityClassCode) {
            this.entityClassCode = entityClassCode;
            return this;
        }

        public Builder withEntityClassProfile(String profile) {
            this.profile = profile;
            return this;
        }

        public EntityClassRef build() {
            if (null == this.profile) {
                this.profile = "";
            }
            return new EntityClassRef(this.entityClassId, this.entityClassCode, this.profile);
        }
    }
}

