/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.entity;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldConfig;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import java.util.Optional;

public class EntityFieldName {
    private static final String RELATIONAL_FIELD_NAME_SUFFIX = ".id";
    private static final String RELATIONAL_FIELD_ORIGINAL_NAME_SUFFIX = "_id";
    private IEntityField field;

    public EntityFieldName(IEntityField field) {
        this.field = field;
    }

    public String dynamicName() {
        return this.field.name();
    }

    public Optional<String> originalName() {
        FieldConfig config = this.field.config();
        if (config != null) {
            if (config.getJdbcType() != 0) {
                return Optional.of(this.buildOriginalName());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EntityFieldName{");
        sb.append("dynamicName=").append(this.dynamicName());
        sb.append(", ");
        sb.append("originalName=").append(this.originalName().orElse(""));
        sb.append('}');
        return sb.toString();
    }

    private String buildOriginalName() {
        String name = this.field.name();
        if (name.endsWith(RELATIONAL_FIELD_NAME_SUFFIX)) {
            StringBuilder buff = new StringBuilder();
            buff.append(name);
            int replaceIndex = name.length() - RELATIONAL_FIELD_NAME_SUFFIX.length();
            buff.replace(replaceIndex, buff.length(), RELATIONAL_FIELD_ORIGINAL_NAME_SUFFIX);
            return buff.toString();
        }
        return name;
    }
}

