/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.entity;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldConfig;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relation;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public enum FieldLikeRelationType {
    ONE2ONE("onetoone", rel -> FieldLikeRelationType.toField(rel, FieldType.LONG, "id", true, false, true), true),
    ONE2MANY("onetomany", rel -> FieldLikeRelationType.toField(rel, FieldType.LONG, "id", true, false, false), false),
    MANY2ONE("manytoone", rel -> FieldLikeRelationType.toField(rel, FieldType.LONG, "id", true, false, true), true),
    MULTI_VALUES("multivalues", rel -> FieldLikeRelationType.toField(rel, FieldType.STRINGS, "id", true, false, true), true);

    private String name;
    private boolean ownerSide;
    private Function<Relation, IEntityField> fieldTransformer;

    private FieldLikeRelationType(String name, Function<Relation, IEntityField> fieldTransformer, boolean ownerSide) {
        this.fieldTransformer = fieldTransformer;
        this.name = name;
        this.ownerSide = ownerSide;
    }

    public String getName() {
        return this.name;
    }

    public boolean isOwnerSide() {
        return this.ownerSide;
    }

    public IEntityField getField(Relation rel) {
        return this.fieldTransformer.apply(rel);
    }

    public static IEntityField toField(Relation relation, FieldType fieldType, String defaultName, boolean searchable, boolean isIdentifier, boolean ownerSide) {
        String relationName = relation.getName();
        String relatedEntityName = relationName == null || relationName.isEmpty() ? relation.getEntityClassName() : relationName;
        String fieldName = (ownerSide ? relatedEntityName : relation.getRelOwnerClassName()).concat(".").concat(defaultName);
        Long fieldId = relation.getId();
        FieldConfig fieldConfig = FieldConfig.build().searchable(searchable).identifie(isIdentifier);
        return new EntityField(fieldId, fieldName, fieldType, fieldConfig);
    }

    public static Optional<FieldLikeRelationType> from(String name) {
        return Stream.of(FieldLikeRelationType.values()).filter(x -> x.name.equalsIgnoreCase(name)).findFirst();
    }
}

