/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.entity;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.EntityClassRef;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.EntityClassType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relationship;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface IEntityClass {
    public long id();

    public String code();

    default public String appCode() {
        return "";
    }

    public String name();

    default public String profile() {
        return "";
    }

    public int version();

    public int level();

    public Collection<Relationship> relationship();

    public Collection<IEntityClass> relationsEntityClasss();

    public Optional<IEntityClass> father();

    public Collection<IEntityClass> family();

    public Collection<IEntityField> fields();

    default public Collection<IEntityField> fields(Predicate<? super IEntityField> filter) {
        return this.fields().stream().filter(filter).collect(Collectors.toList());
    }

    public Optional<IEntityField> field(String var1);

    public Optional<IEntityField> field(long var1);

    default public EntityClassRef ref() {
        return EntityClassRef.Builder.anEntityClassRef().withEntityClassId(this.id()).withEntityClassCode(this.code()).build();
    }

    default public boolean isAny() {
        return false;
    }

    default public boolean isDynamic() {
        return true;
    }

    default public boolean isCompatibility(long id) {
        for (IEntityClass entityClass : this.family()) {
            if (entityClass.id() != id) continue;
            return true;
        }
        return false;
    }

    default public boolean isCompatibility(IEntityClass entityClass) {
        return this.isCompatibility(entityClass.id());
    }

    default public EntityClassType type() {
        return EntityClassType.UNKNOWN;
    }
}

