/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.EntityClassRef;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.EntityClassType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relationship;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

public class EntityClass
implements IEntityClass {
    private long id;
    private String name;
    private String code;
    private String appCode;
    private int version;
    private int level;
    private String profile;
    private Collection<Relationship> relations;
    private IEntityClass father;
    private Collection<IEntityField> fields = Collections.emptyList();
    private EntityClassType type;

    private EntityClass() {
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public String appCode() {
        return this.appCode;
    }

    @Override
    public String profile() {
        return this.profile;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int version() {
        return this.version;
    }

    @Override
    public int level() {
        return this.level;
    }

    @Override
    public EntityClassRef ref() {
        return EntityClassRef.Builder.anEntityClassRef().withEntityClassId(this.id).withEntityClassCode(this.code).withEntityClassProfile(this.profile).build();
    }

    @Override
    public EntityClassType type() {
        return this.type;
    }

    @Override
    public boolean isDynamic() {
        return this.type == null || this.type.equals((Object)EntityClassType.DYNAMIC);
    }

    @Override
    public Collection<Relationship> relationship() {
        ArrayList<Relationship> relations = new ArrayList<Relationship>();
        if (this.relations != null) {
            relations.addAll(this.relations);
        }
        if (null != this.father) {
            relations.addAll(this.father.relationship());
        }
        return relations;
    }

    @Override
    @Deprecated
    public Collection<IEntityClass> relationsEntityClasss() {
        return null;
    }

    @Override
    public Optional<IEntityClass> father() {
        return Optional.ofNullable(this.father);
    }

    @Override
    public Collection<IEntityClass> family() {
        ArrayList<IEntityClass> familyList = new ArrayList<IEntityClass>(this.level);
        Optional<IEntityClass> current = Optional.of(this);
        while (current.isPresent()) {
            familyList.add(0, current.get());
            current = ((IEntityClass)current.get()).father();
        }
        return familyList;
    }

    @Override
    public Collection<IEntityField> fields() {
        ArrayList<IEntityField> entityFields = new ArrayList<IEntityField>(this.fields);
        if (null != this.relations) {
            this.relations.forEach(r -> {
                if (null != r && r.isSelfRelation(this.id) && r.getEntityField() != null) {
                    entityFields.add(r.getEntityField());
                }
            });
        }
        if (null != this.father) {
            entityFields.addAll(this.father.fields());
        }
        return entityFields;
    }

    @Override
    public Optional<IEntityField> field(String name) {
        Optional<IEntityField> entityFieldOp = this.fields.stream().filter(f -> name.equals(f.name())).findFirst();
        if (entityFieldOp.isPresent()) {
            return entityFieldOp;
        }
        if (this.relations != null) {
            for (Relationship relation : this.relations) {
                if (!relation.isSelfRelation(this.id) || relation.getEntityField() == null || !relation.getEntityField().name().equals(name)) continue;
                return Optional.of(relation.getEntityField());
            }
        }
        if (null != this.father) {
            return this.father.field(name);
        }
        return entityFieldOp;
    }

    @Override
    public Optional<IEntityField> field(long id) {
        Optional<IEntityField> entityFieldOp = this.fields.stream().filter(f -> id == f.id()).findFirst();
        if (entityFieldOp.isPresent()) {
            return entityFieldOp;
        }
        if (this.relations != null) {
            for (Relationship relation : this.relations) {
                if (!relation.isSelfRelation(this.id) || relation.getEntityField() == null || relation.getEntityField().id() != id) continue;
                return Optional.of(relation.getEntityField());
            }
        }
        if (null != this.father) {
            return this.father.field(id);
        }
        return entityFieldOp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityClass)) {
            return false;
        }
        EntityClass that = (EntityClass)o;
        return this.id == that.id && this.version == that.version && this.level == that.level && Objects.equals(this.profile, that.profile) && Objects.equals(this.name, that.name) && Objects.equals(this.code, that.code) && Objects.equals(this.appCode, that.appCode) && Objects.equals(this.father, that.father) && Objects.equals(this.relations, that.relations) && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.code, this.version, this.level, this.relations, this.father, this.fields);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("EntityClass{");
        sb.append("id=").append(this.id);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", code='").append(this.code).append('\'');
        sb.append(", profile='").append(this.profile).append('\'');
        sb.append(", appCode='").append(this.appCode).append('\'');
        sb.append(", version=").append(this.version);
        sb.append(", level=").append(this.level);
        sb.append(", relations=").append(this.relations);
        sb.append(", father=").append(this.father);
        sb.append(", fields=").append(this.fields);
        sb.append('}');
        return sb.toString();
    }

    public static final class Builder {
        private long id;
        private String name;
        private String code;
        private String appCode;
        private int version;
        private int level;
        private String profile;
        private Collection<Relationship> relations = Collections.emptyList();
        private IEntityClass father;
        private Collection<IEntityField> fields = Collections.emptyList();
        private EntityClassType type;

        private Builder() {
        }

        public static Builder anEntityClass() {
            return new Builder();
        }

        public Builder withId(long id) {
            this.id = id;
            return this;
        }

        public Builder withProfile(String profile) {
            this.profile = profile;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withCode(String code) {
            this.code = code;
            return this;
        }

        public Builder withAppCode(String appCode) {
            this.appCode = appCode;
            return this;
        }

        public Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder withLevel(int level) {
            this.level = level;
            return this;
        }

        public Builder withRelations(Collection<Relationship> relations) {
            this.relations = relations;
            return this;
        }

        public Builder withFather(IEntityClass father) {
            this.father = father;
            return this;
        }

        public Builder withFields(Collection<IEntityField> fields) {
            this.fields = fields;
            return this;
        }

        public Builder withType(EntityClassType type) {
            this.type = type;
            return this;
        }

        public Builder withField(IEntityField field) {
            if (Collections.emptyList().getClass().equals(this.fields.getClass())) {
                this.fields = new ArrayList<IEntityField>(this.fields);
            }
            this.fields.add(field);
            return this;
        }

        public EntityClass build() {
            EntityClass entityClass = new EntityClass();
            entityClass.id = this.id;
            entityClass.code = this.code;
            entityClass.appCode = this.appCode;
            entityClass.name = this.name;
            entityClass.level = this.level;
            entityClass.version = this.version;
            entityClass.father = this.father;
            entityClass.fields = this.fields;
            entityClass.relations = this.relations;
            entityClass.type = this.type;
            if (this.profile == null) {
                entityClass.profile = "";
            } else {
                entityClass.profile = this.profile;
            }
            return entityClass;
        }
    }
}

