/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldConfig;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EntityField
implements IEntityField,
Serializable {
    public static final IEntityField ILLUSORY_FIELD = Builder.anEntityField().withFieldType(FieldType.LONG).withId(0L).withName("-").build();
    public static final IEntityField ID_ENTITY_FIELD = new EntityField(Long.MAX_VALUE, "id", FieldType.LONG, FieldConfig.Builder.anFieldConfig().withIdentifie(true).build());
    public static final IEntityField CREATE_TIME_FILED = new EntityField(0x7FFFFFFFFFFFFFFEL, "createTime", FieldType.LONG, FieldConfig.Builder.anFieldConfig().withFieldSense(FieldConfig.FieldSense.CREATE_TIME).build());
    public static final IEntityField UPDATE_TIME_FILED = new EntityField(0x7FFFFFFFFFFFFFFDL, "updateTime", FieldType.LONG, FieldConfig.Builder.anFieldConfig().withFieldSense(FieldConfig.FieldSense.UPDATE_TIME).build());
    @JsonProperty(value="id")
    private long id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="cnName")
    private String cnName;
    @JsonProperty(value="type")
    private FieldType fieldType;
    @JsonProperty(value="dictId")
    private String dictId;
    @JsonProperty(value="defaultValue")
    private String defaultValue;
    @JsonProperty(value="config")
    private FieldConfig config;
    @JsonProperty(value="calculationType")
    private CalculationType calculationType;

    public EntityField() {
    }

    @Deprecated
    public EntityField(long id, String name, FieldType fieldType) {
        this(id, name, fieldType, null);
    }

    @Deprecated
    public EntityField(long id, String name, FieldType fieldType, FieldConfig config, String dictId, String defaultValue) {
        this(id, name, fieldType, config);
        this.dictId = dictId;
        this.defaultValue = defaultValue;
    }

    @Deprecated
    public EntityField(long id, String name, String cnName, FieldType fieldType, FieldConfig config, String dictId, String defaultValue) {
        this(id, name, fieldType, config);
        this.cnName = cnName;
        this.dictId = dictId;
        this.defaultValue = defaultValue;
    }

    @Deprecated
    public EntityField(long id, String name, FieldType fieldType, FieldConfig config) {
        this.id = id;
        this.name = name;
        this.fieldType = fieldType;
        this.config = config == null ? FieldConfig.build() : config;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String cnName() {
        return this.cnName;
    }

    @Override
    public FieldType type() {
        return this.fieldType;
    }

    @Override
    public FieldConfig config() {
        return this.config;
    }

    @Override
    public String dictId() {
        return this.dictId;
    }

    @Override
    public Optional<String> defaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }

    @Override
    public CalculationType calculationType() {
        if (this.calculationType == null) {
            return CalculationType.STATIC;
        }
        return this.calculationType;
    }

    @Override
    public boolean indexAttachment() {
        return this.config.indexAttachment();
    }

    public String getDictId() {
        return this.dictId;
    }

    public void setDictId(String dictId) {
        this.dictId = dictId;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getCnName() {
        return this.cnName;
    }

    public void setCnName(String cnName) {
        this.cnName = cnName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityField)) {
            return false;
        }
        EntityField entityField = (EntityField)o;
        return this.id == entityField.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return new StringJoiner(", ", EntityField.class.getSimpleName() + "[", "]").add("id=" + this.id).add("name='" + this.name + "'").add("cnName='" + this.cnName + "'").add("fieldType=" + (Object)((Object)this.fieldType)).add("dictId='" + this.dictId + "'").add("defaultValue='" + this.defaultValue + "'").add("config=" + this.config).add("calculationType=" + (Object)((Object)this.calculationType)).toString();
    }

    public static final class Builder {
        private long id;
        private String name;
        private String cnName;
        private FieldType fieldType;
        private String dictId;
        private String defaultValue;
        private FieldConfig config;

        private Builder() {
        }

        public static Builder anEntityField() {
            return new Builder();
        }

        public Builder withId(long id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withCnName(String cnName) {
            this.cnName = cnName;
            return this;
        }

        public Builder withFieldType(FieldType fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public Builder withDictId(String dictId) {
            this.dictId = dictId;
            return this;
        }

        public Builder withDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder withConfig(FieldConfig config) {
            this.config = config;
            return this;
        }

        public EntityField build() {
            EntityField entityField = new EntityField();
            entityField.id = this.id;
            entityField.name = this.name;
            entityField.cnName = this.cnName;
            entityField.fieldType = this.fieldType;
            entityField.dictId = this.dictId;
            entityField.defaultValue = this.defaultValue;
            entityField.config = this.config == null ? FieldConfig.DEFAULT_CONFIG : this.config;
            entityField.calculationType = null == this.config || null == this.config.getCalculation() ? CalculationType.STATIC : this.config.getCalculation().getCalculationType();
            return entityField;
        }
    }
}

