/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldConfig;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DateTimeValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.EmptyTypedValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.LongValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class EntityValue
implements IEntityValue,
Cloneable,
Serializable {
    private IEntity entity;
    private Map<Long, IValue> values;

    public EntityValue(IEntity entity) {
        this.entity = entity;
    }

    @Override
    public int size() {
        return this.values == null ? 0 : this.values.size();
    }

    @Override
    public Optional<IValue> getValue(IEntityField field) {
        if (field.config().isIdentifie()) {
            return Optional.of(new LongValue(field, this.entity.id()));
        }
        if (field.config().getFieldSense() != FieldConfig.FieldSense.NORMAL) {
            switch (field.config().getFieldSense()) {
                case UPDATE_TIME: {
                    return Optional.of(new DateTimeValue(field, DateTimeValue.toLocalDateTime(this.entity.time())));
                }
            }
            return Optional.empty();
        }
        return this.getValue(field.id());
    }

    @Override
    public Optional<IValue> getValue(String fieldName) {
        if (this.values == null) {
            return Optional.empty();
        }
        return this.values.values().stream().filter((? super T v) -> v.getField().name().equals(fieldName)).findFirst();
    }

    @Override
    public Optional<IValue> getValue(long fieldId) {
        if (this.values == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.values.get(fieldId));
    }

    @Override
    public IEntityValue addValue(IValue value) {
        this.lazyInit();
        IValue oldValue = this.values.get(value.getField().id());
        if (oldValue == null || !oldValue.equals(value)) {
            this.values.put(value.getField().id(), value);
        }
        return this;
    }

    @Override
    public Collection<IValue> values() {
        if (this.values == null) {
            return Collections.emptyList();
        }
        return this.values.values();
    }

    @Override
    public IEntityValue addValues(Collection<IValue> values) {
        this.lazyInit();
        values.stream().forEach(v -> this.addValue((IValue)v));
        return this;
    }

    @Override
    public Optional<IValue> remove(IEntityField field) {
        if (this.values == null) {
            return Optional.empty();
        }
        IValue oldValue = this.values.remove(field.id());
        if (oldValue != null) {
            return Optional.of(oldValue);
        }
        return Optional.empty();
    }

    @Override
    public void filter(Predicate<? super IValue> predicate) {
        if (this.values != null) {
            this.values.entrySet().removeIf(entry -> !predicate.test((IValue)entry.getValue()));
        }
    }

    @Override
    public IEntityValue clear() {
        if (this.values != null) {
            this.values.clear();
        }
        return this;
    }

    @Override
    public boolean isDirty() {
        if (this.values == null || this.values.isEmpty()) {
            return false;
        }
        return this.values.values().stream().filter((? super T v) -> v.isDirty()).count() > 0L;
    }

    @Override
    public void squeezeEmpty() {
        long[] emptyValueFieldIds;
        if (this.values == null || this.values.isEmpty()) {
            return;
        }
        for (long id : emptyValueFieldIds = this.values.entrySet().stream().filter((? super T entry) -> {
            IValue v = (IValue)entry.getValue();
            if (EmptyTypedValue.class.isInstance(v)) {
                return !v.getAttachment().isPresent();
            }
            return false;
        }).mapToLong(entity -> (Long)entity.getKey()).toArray()) {
            this.values.remove(id);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EntityValue cloneValue = new EntityValue(this.entity);
        cloneValue.values = new HashMap<Long, IValue>(this.values);
        return cloneValue;
    }

    private void lazyInit() {
        if (this.values == null) {
            this.values = new HashMap<Long, IValue>();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityValue)) {
            return false;
        }
        EntityValue that = (EntityValue)o;
        return this.equalsValues(that);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("[");
        int emptyLen = buff.length();
        this.values.values().stream().forEach(v -> {
            if (buff.length() > emptyLen) {
                buff.append(" , ");
            }
            buff.append("{").append("id: ").append(v.getField().id()).append(", ").append("name: ").append(v.getField().name()).append(", ").append("type: ").append(v.getField().type().getType()).append(", ").append("value: ").append(v.getValue().toString()).append("}");
        });
        buff.append("]");
        return buff.toString();
    }

    private boolean equalsValues(EntityValue that) {
        if (that == null) {
            return false;
        }
        Map<Long, IValue> thatValues = that.values;
        if (this.values == thatValues) {
            return true;
        }
        if (thatValues.size() != this.values.size()) {
            return false;
        }
        for (Long id : this.values.keySet()) {
            IValue thatValue;
            IValue thisValue = this.values.get(id);
            if (thisValue.equals(thatValue = thatValues.get(id))) continue;
            return false;
        }
        return true;
    }
}

