/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.values;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractValue<V>
implements IValue<V>,
Serializable {
    private boolean dirty;
    private String attachment;
    private IEntityField field;
    private V value;

    public AbstractValue(IEntityField field, V value) {
        this(field, value, null);
    }

    public AbstractValue(IEntityField field, V value, String attachment) {
        this.field = field;
        this.value = value;
        this.attachment = attachment;
        this.dirty = true;
    }

    @Override
    public IEntityField getField() {
        return this.field;
    }

    @Override
    public void setField(IEntityField field) {
        this.field = field;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public Optional<String> getAttachment() {
        return Optional.ofNullable(this.attachment);
    }

    @Override
    public void setStringValue(String value) {
        this.value = this.fromString(value);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void dirty() {
        this.dirty = true;
    }

    @Override
    public void neat() {
        this.dirty = false;
    }

    @Override
    public String valueToString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return "NULL";
    }

    @Override
    public abstract long valueToLong();

    @Override
    public IValue<V> copy(IEntityField newField, String attachment) {
        if (!this.skipTypeCheckWithCopy()) {
            this.checkType(newField);
        }
        return this.doCopy(newField, attachment);
    }

    @Override
    public IValue<V> copy(V value) {
        if (!this.getValue().getClass().equals(value.getClass())) {
            throw new IllegalArgumentException(String.format("Copy a value of type %s, but receives an unexpected type %s.", this.getField().name(), value.getClass().getSimpleName()));
        }
        return this.doCopy(value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName()).append("{");
        sb.append("field=").append(this.field);
        sb.append(", value=").append(this.value);
        sb.append(", dirty=").append(this.dirty);
        if (this.attachment != null) {
            sb.append(", attachment=").append(this.attachment);
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractValue that = (AbstractValue)o;
        return Objects.equals(this.field.id(), that.field.id()) && Objects.equals(this.value, that.value) && Objects.equals(this.attachment, that.attachment);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.value, this.attachment);
    }

    @Override
    public int compareTo(IValue o) {
        return ((Comparable)this.getValue()).compareTo(o.getValue());
    }

    protected abstract IValue<V> doCopy(IEntityField var1, String var2);

    protected abstract IValue<V> doCopy(V var1);

    protected boolean skipTypeCheckWithCopy() {
        return false;
    }

    abstract V fromString(String var1);

    private void checkType(IEntityField newFiled) {
        if (newFiled.type() != this.getField().type()) {
            throw new IllegalArgumentException(String.format("Field that doesn't fit.[newFieldId=%d, oldFieldId=%d, newType=%s, oldType=%s]", newFiled.id(), this.getField().id(), newFiled.type().name(), this.getField().type().name()));
        }
    }
}

