/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.values;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.AbstractValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeValue
extends AbstractValue<LocalDateTime> {
    private final Logger logger = LoggerFactory.getLogger(DateTimeValue.class);
    public static final ZoneId ZONE_ID = ZoneId.of("Asia/Shanghai");
    public static final LocalDateTime MIN_DATE_TIME = LocalDateTime.of(LocalDate.of(0, 1, 1), LocalTime.MIN);
    public static final LocalDateTime MAX_DATE_TIME = LocalDateTime.of(LocalDate.of(9999, 1, 1), LocalTime.MAX);

    public DateTimeValue(IEntityField field, LocalDateTime value) {
        super(field, value);
    }

    public DateTimeValue(IEntityField field, LocalDateTime value, String attachment) {
        super(field, value, attachment);
    }

    @Override
    LocalDateTime fromString(String value) {
        if (value == null) {
            return null;
        }
        try {
            long timestamp = Long.parseLong(value);
            return DateTimeValue.toLocalDateTime(timestamp);
        }
        catch (Exception ex) {
            this.logger.error("{}", (Throwable)ex);
            return null;
        }
    }

    @Override
    public long valueToLong() {
        Instant instant = ((LocalDateTime)this.getValue()).atZone(ZONE_ID).toInstant();
        return instant.toEpochMilli();
    }

    @Override
    protected IValue<LocalDateTime> doCopy(IEntityField newField, String attachment) {
        return new DateTimeValue(newField, (LocalDateTime)this.getValue(), attachment);
    }

    @Override
    protected IValue<LocalDateTime> doCopy(LocalDateTime value) {
        return new DateTimeValue(this.getField(), value, (String)this.getAttachment().orElse(null));
    }

    @Override
    public String valueToString() {
        return Long.toString(this.valueToLong());
    }

    @Override
    public boolean compareByString() {
        return false;
    }

    public static LocalDateTime toLocalDateTime(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZONE_ID);
    }
}

