/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.values;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.AbstractValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.able.CalculationsAble;
import java.math.BigDecimal;

public class DecimalValue
extends AbstractValue<BigDecimal>
implements CalculationsAble<BigDecimal> {
    public DecimalValue(IEntityField field, BigDecimal value) {
        this(field, value, (String)null);
    }

    public DecimalValue(IEntityField field, BigDecimal value, String attachment) {
        super(field, DecimalValue.buildWellBigDecimal(field, value), attachment);
    }

    @Override
    protected BigDecimal fromString(String value) {
        if (value != null) {
            return DecimalValue.buildWellBigDecimal(this.getField(), new BigDecimal(value));
        }
        return null;
    }

    @Override
    public long valueToLong() {
        return ((BigDecimal)this.getValue()).longValue();
    }

    @Override
    protected IValue<BigDecimal> doCopy(IEntityField newField, String attachment) {
        return new DecimalValue(newField, (BigDecimal)this.getValue(), attachment);
    }

    @Override
    protected IValue<BigDecimal> doCopy(BigDecimal value) {
        return new DecimalValue(this.getField(), value, (String)this.getAttachment().orElse(null));
    }

    @Override
    public String valueToString() {
        return ((BigDecimal)this.getValue()).toPlainString();
    }

    private static BigDecimal buildWellBigDecimal(IEntityField field, BigDecimal value) {
        BigDecimal wellValue;
        String plainValue = value.toPlainString();
        String[] checkValues = plainValue.split("\\.");
        Long.parseLong(checkValues[0]);
        if (checkValues.length > 1) {
            Long.parseLong(checkValues[1]);
        }
        if (plainValue.indexOf(".") < 0) {
            plainValue = value.longValue() + ".0";
            wellValue = new BigDecimal(plainValue);
        } else {
            wellValue = value;
        }
        return wellValue;
    }

    @Override
    public CalculationsAble<BigDecimal> plus(IValue<BigDecimal> other) {
        BigDecimal left = (BigDecimal)this.getValue();
        BigDecimal right = other.getValue();
        BigDecimal reuslt = left.add(right);
        return new DecimalValue(this.getField(), reuslt, this.getAttachment().orElse("null"));
    }

    @Override
    public CalculationsAble<BigDecimal> subtract(IValue<BigDecimal> other) {
        BigDecimal left = (BigDecimal)this.getValue();
        BigDecimal right = other.getValue();
        BigDecimal reuslt = left.subtract(right);
        return new DecimalValue(this.getField(), reuslt, this.getAttachment().orElse("null"));
    }

    @Override
    public CalculationsAble<BigDecimal> decrement() {
        return new DecimalValue(this.getField(), ((BigDecimal)this.getValue()).subtract(BigDecimal.ONE), this.getAttachment().orElse("null"));
    }

    @Override
    public CalculationsAble<BigDecimal> increment() {
        return new DecimalValue(this.getField(), ((BigDecimal)this.getValue()).add(BigDecimal.ONE), this.getAttachment().orElse("null"));
    }
}

