/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.values;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.AbstractValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.able.CalculationsAble;

public class LongValue
extends AbstractValue<Long>
implements CalculationsAble<Long> {
    public LongValue(IEntityField field, int value) {
        super(field, Long.valueOf(value));
    }

    public LongValue(IEntityField field, long value) {
        super(field, value);
    }

    public LongValue(IEntityField field, int value, String attachment) {
        super(field, Long.valueOf(value), attachment);
    }

    public LongValue(IEntityField field, long value, String attachment) {
        super(field, value, attachment);
    }

    @Override
    Long fromString(String value) {
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    @Override
    public long valueToLong() {
        return (Long)this.getValue();
    }

    @Override
    protected IValue<Long> doCopy(IEntityField newField, String attachment) {
        return new LongValue(newField, (Long)this.getValue(), attachment);
    }

    @Override
    protected IValue<Long> doCopy(Long value) {
        return new LongValue(this.getField(), value, (String)this.getAttachment().orElse(null));
    }

    @Override
    public boolean compareByString() {
        return false;
    }

    @Override
    public CalculationsAble<Long> plus(IValue<Long> other) {
        long left = (Long)this.getValue();
        long right = other.getValue();
        return new LongValue(this.getField(), left + right, this.getAttachment().orElse("null"));
    }

    @Override
    public CalculationsAble<Long> subtract(IValue<Long> other) {
        long left = (Long)this.getValue();
        long right = other.getValue();
        return new LongValue(this.getField(), left - right, this.getAttachment().orElse("null"));
    }

    @Override
    public CalculationsAble<Long> decrement() {
        return new LongValue(this.getField(), (Long)this.getValue() - 1L, this.getAttachment().orElse("null"));
    }

    @Override
    public CalculationsAble<Long> increment() {
        return new LongValue(this.getField(), (Long)this.getValue() + 1L, this.getAttachment().orElse("null"));
    }
}

