/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.values;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.AbstractValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.StringValue;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class StringsValue
extends AbstractValue<String[]> {
    private static final String DELIMITER = ",";

    public StringsValue(IEntityField field, String ... value) {
        super(field, value);
    }

    public StringsValue(IEntityField field, String[] value, String attachment) {
        super(field, value, attachment);
    }

    @Override
    String[] fromString(String value) {
        return value == null ? null : value.split(DELIMITER);
    }

    @Override
    public long valueToLong() {
        throw new UnsupportedOperationException("A string cannot be represented by a number.");
    }

    @Override
    public String valueToString() {
        return String.join((CharSequence)DELIMITER, (CharSequence[])this.getValue());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringsValue)) {
            return false;
        }
        String[] thatValues = (String[])((StringsValue)o).getValue();
        if (thatValues.length != ((String[])this.getValue()).length) {
            return false;
        }
        for (String v : (String[])this.getValue()) {
            boolean found = false;
            for (String tv : thatValues) {
                if (!tv.equals(v)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return this.getAttachment().equals(((StringsValue)o).getAttachment());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getField(), this.getValue());
    }

    @Override
    public String toString() {
        return "StringValue{field=" + this.getField() + ", value=" + Arrays.toString((Object[])this.getValue()) + '}';
    }

    @Override
    protected IValue<String[]> doCopy(IEntityField newField, String attachment) {
        return new StringsValue(newField, (String[])this.getValue(), attachment);
    }

    @Override
    protected IValue<String[]> doCopy(String[] value) {
        return new StringsValue(this.getField(), value, (String)this.getAttachment().orElse(null));
    }

    public static String[] toStrings(String stringValues) {
        return stringValues.split(DELIMITER);
    }

    @Override
    public int compareTo(IValue o) {
        String[] sourceValues = (String[])this.getValue();
        String[] targetValues = (String[])((StringsValue)o).getValue();
        String sourceValue = "";
        if (sourceValues != null) {
            sourceValue = Arrays.stream(sourceValues).collect(Collectors.joining());
        }
        String targetValue = "";
        if (targetValues != null) {
            targetValue = Arrays.stream(targetValues).collect(Collectors.joining());
        }
        return sourceValue.compareTo(targetValue);
    }

    @Override
    public boolean include(IValue o) {
        block4: {
            block3: {
                String[] otherValues;
                if (!StringsValue.class.isInstance(o)) break block3;
                String[] currentValues = (String[])this.getValue();
                for (String v : otherValues = (String[])((StringsValue)o).getValue()) {
                    if (v == null) continue;
                    for (String cv : currentValues) {
                        if (!v.equals(cv)) continue;
                        return true;
                    }
                }
                break block4;
            }
            if (!StringValue.class.isInstance(o)) break block4;
            String[] currentValues = (String[])this.getValue();
            String otherValue = (String)((StringValue)o).getValue();
            for (String cv : currentValues) {
                if (cv == null || !otherValue.equals(cv)) continue;
                return true;
            }
        }
        return false;
    }
}

