/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.values.verifier;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.verifier.DecimalValueVerifier;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.verifier.LongValueVerifier;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.verifier.StringValueVerifier;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.verifier.StringsValueVerifier;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.verifier.ValueVerifier;
import java.util.HashMap;
import java.util.Map;

public class VerifierFactory {
    private static final ValueVerifier DEFAULT_VALUE_VERIFIER = new NoVerifier();
    private static Map<FieldType, ValueVerifier> VERIFIER_MAP = new HashMap<FieldType, ValueVerifier>();

    public static ValueVerifier getVerifier(FieldType type) {
        ValueVerifier valueVerifier = VERIFIER_MAP.get((Object)type);
        if (valueVerifier == null) {
            return DEFAULT_VALUE_VERIFIER;
        }
        return valueVerifier;
    }

    static {
        VERIFIER_MAP.put(FieldType.STRING, new StringValueVerifier());
        VERIFIER_MAP.put(FieldType.LONG, new LongValueVerifier());
        VERIFIER_MAP.put(FieldType.DECIMAL, new DecimalValueVerifier());
        VERIFIER_MAP.put(FieldType.STRINGS, new StringsValueVerifier());
    }

    static class NoVerifier
    implements ValueVerifier {
        NoVerifier() {
        }
    }
}

