/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.utils;

import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Condition;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionOperator;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.AbstractValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.BooleanValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DateTimeValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.DecimalValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.EmptyTypedValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.EnumValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.LongValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.StringValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.StringsValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.ValueWithEmpty;
import com.xforceplus.ultraman.oqsengine.pojo.utils.TimeUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IValueUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IValueUtils.class);

    public static String serialize(IValue value) {
        if (value == null || value.getValue() == null) {
            return null;
        }
        if (value instanceof StringValue || value instanceof StringsValue || value instanceof DecimalValue || value instanceof EnumValue || value instanceof BooleanValue) {
            return value.valueToString();
        }
        if (value instanceof LongValue || value instanceof DateTimeValue) {
            return Long.toString(value.valueToLong());
        }
        return value.valueToString();
    }

    public static Condition deserializeCondition(String rawValue, ConditionOperator operator, IEntityField entityField) {
        if (operator.equals((Object)ConditionOperator.MULTIPLE_EQUALS)) {
            String[] rawValues = rawValue.split(",");
            IValue[] values = new IValue[rawValues.length];
            for (int i = 0; i < rawValues.length; ++i) {
                values[i] = IValueUtils.deserialize(rawValues[i], entityField);
            }
            return new Condition(entityField, operator, values);
        }
        return new Condition(entityField, operator, IValueUtils.deserialize(rawValue, entityField));
    }

    public static IValue deserialize(String rawValue, IEntityField entityField) {
        AbstractValue retValue = null;
        if (rawValue == null) {
            return null;
        }
        switch (entityField.type()) {
            case STRING: {
                retValue = new StringValue(entityField, rawValue);
                break;
            }
            case STRINGS: {
                retValue = new StringsValue(entityField, rawValue.split(","));
                break;
            }
            case BOOLEAN: {
                retValue = new BooleanValue(entityField, Boolean.parseBoolean(rawValue));
                break;
            }
            case DATETIME: {
                long timestamp = Long.parseLong(rawValue);
                LocalDateTime time = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), DateTimeValue.ZONE_ID);
                retValue = new DateTimeValue(entityField, time);
                break;
            }
            case ENUM: {
                retValue = new EnumValue(entityField, rawValue);
                break;
            }
            case LONG: {
                retValue = new LongValue(entityField, Long.parseLong(rawValue));
                break;
            }
            case DECIMAL: {
                retValue = new DecimalValue(entityField, new BigDecimal(rawValue));
                break;
            }
        }
        return retValue;
    }

    public static IValue<?> toIValue(IEntityField field, Object result) {
        try {
            if (result.getClass().equals(ValueWithEmpty.class)) {
                return new EmptyTypedValue(field);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("raw : [{}], fieldId : [{}], config : [{}]]", new Object[]{result, field.id(), field.config().toString()});
            }
            switch (field.type()) {
                case BOOLEAN: {
                    return new BooleanValue(field, (Boolean)result);
                }
                case ENUM: {
                    return new EnumValue(field, (String)result);
                }
                case DATETIME: {
                    if (result instanceof Date) {
                        return new DateTimeValue(field, TimeUtils.convert((Date)result));
                    }
                    if (result instanceof LocalDateTime) {
                        return new DateTimeValue(field, (LocalDateTime)result);
                    }
                    return new DateTimeValue(field, TimeUtils.convert((Long)result));
                }
                case LONG: {
                    if (result instanceof Integer) {
                        result = ((Integer)result).longValue();
                    }
                    return new LongValue(field, (Long)result);
                }
                case STRING: {
                    return new StringValue(field, (String)result);
                }
                case STRINGS: {
                    return new StringsValue(field, (String[])result);
                }
                case DECIMAL: {
                    Scale scale;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("in decimal, raw : [{}], fieldId : [{}], precision : [{}], scale : [{}]]", new Object[]{result, field.id(), field.config().getPrecision(), field.config().scale()});
                    }
                    BigDecimal r = field.config().getPrecision() > 0 ? (!(scale = Scale.getInstance(field.config().scale())).equals((Object)Scale.UN_KNOW) ? IValueUtils.toBigDecimal(result, field.config().getPrecision(), scale.getMode()) : IValueUtils.toBigDecimal(result, null, null)) : IValueUtils.toBigDecimal(result, null, null);
                    return new DecimalValue(field, r);
                }
            }
            throw new IllegalArgumentException("unknown field type.");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("toIValue failed, message [%s]", e.getMessage()));
        }
    }

    private static BigDecimal toBigDecimal(Object value, Integer precision, Integer model) {
        BigDecimal toValue = null;
        if (value instanceof String) {
            toValue = new BigDecimal((String)value);
        } else if (value instanceof Long) {
            toValue = BigDecimal.valueOf((Long)value);
        } else if (value instanceof Integer) {
            toValue = BigDecimal.valueOf(((Integer)value).intValue());
        } else if (value instanceof Double) {
            toValue = BigDecimal.valueOf((Double)value);
        } else if (value instanceof Float) {
            toValue = BigDecimal.valueOf(((Float)value).floatValue());
        } else if (value instanceof BigDecimal) {
            toValue = (BigDecimal)value;
        } else {
            throw new IllegalArgumentException(String.format("bigDecimal un-support type[%s], value[%s]", value.getClass(), value));
        }
        if (null != precision && null != model) {
            return toValue.setScale((int)precision, RoundingMode.valueOf(model));
        }
        return toValue;
    }

    public static IValue max(IEntityField field) {
        switch (field.type()) {
            case DECIMAL: {
                return new DecimalValue(field, new BigDecimal(Long.MAX_VALUE));
            }
            case LONG: {
                return new LongValue(field, Long.MAX_VALUE);
            }
            case DATETIME: {
                return new DateTimeValue(field, DateTimeValue.MAX_DATE_TIME);
            }
        }
        throw new IllegalArgumentException(String.format("The current type(%s) has no maximum value.", field.type().name()));
    }

    public static IValue min(IEntityField field) {
        switch (field.type()) {
            case DECIMAL: {
                return new DecimalValue(field, new BigDecimal(Long.MIN_VALUE));
            }
            case LONG: {
                return new LongValue(field, Long.MIN_VALUE);
            }
            case DATETIME: {
                return new DateTimeValue(field, DateTimeValue.MIN_DATE_TIME);
            }
        }
        throw new IllegalArgumentException(String.format("The current type(%s) has no maximum value.", field.type().name()));
    }

    public static IValue zero(IEntityField field) {
        switch (field.type()) {
            case DECIMAL: {
                return new DecimalValue(field, BigDecimal.ZERO);
            }
            case LONG: {
                return new LongValue(field, 0L);
            }
            case DATETIME: {
                return new DateTimeValue(field, LocalDateTime.of(LocalDate.of(1970, 1, 1), LocalTime.MIN));
            }
        }
        throw new IllegalArgumentException(String.format("The current type(%s) has no maximum value.", field.type().name()));
    }

    public static enum Scale {
        UN_KNOW(0, 7),
        ROUND_HALF_UP(1, 4),
        ROUND_DOWN(2, 1);

        private int scale;
        private int mode;

        private Scale(int scale, int mode) {
            this.scale = scale;
            this.mode = mode;
        }

        public int getScale() {
            return this.scale;
        }

        public int getMode() {
            return this.mode;
        }

        public static Scale getInstance(int v) {
            for (Scale s : Scale.values()) {
                if (s.scale != v) continue;
                return s;
            }
            return UN_KNOW;
        }
    }
}

