/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.conditions;

import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Condition;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionLink;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionNode;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.LinkConditionNode;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ValueConditionNode;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.validation.ConditionValidation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.validation.fieldtype.ConditionOperatorFieldValidationFactory;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class Conditions
implements Serializable {
    private int size;
    private boolean or;
    private boolean range;
    private ConditionNode head;

    public static Conditions buildEmtpyConditions() {
        return new Conditions();
    }

    private Conditions() {
        this.size = 0;
        this.range = false;
        this.or = false;
    }

    public Conditions(Condition condition) {
        this.validate(condition);
        this.head = new ValueConditionNode(condition);
        this.range = condition.isRange();
        this.size = 1;
    }

    public Conditions(ConditionNode head) {
        this.head = head;
        Collection<Condition> conditionCollection = this.collectCondition();
        this.size = conditionCollection.size();
        this.range = conditionCollection.stream().mapToInt(c -> c.isRange() ? 1 : 0).sum() > 0;
    }

    public Conditions addAnd(Condition condition) {
        return this.doAdd(ConditionLink.AND, condition);
    }

    public Conditions addAnd(Conditions conditions, boolean isolation) {
        return this.doAdd(ConditionLink.AND, conditions, isolation);
    }

    public Conditions addOr(Condition condition) {
        return this.doAdd(ConditionLink.OR, condition);
    }

    public Conditions addOr(Conditions conditions, boolean isolation) {
        return this.doAdd(ConditionLink.OR, conditions, isolation);
    }

    public boolean haveOrLink() {
        return this.or;
    }

    public boolean haveRangeCondition() {
        return this.range;
    }

    public Collection<ConditionNode> collect() {
        ArrayList<ConditionNode> nodes = new ArrayList<ConditionNode>(this.size);
        this.iterTree(c -> true, c -> nodes.add((ConditionNode)c), false);
        return nodes;
    }

    public Collection<Condition> collectCondition() {
        ArrayList<Condition> conditionList = new ArrayList<Condition>(this.size);
        this.iterTree(c -> Conditions.isValueNode(c), c -> conditionList.add(((ValueConditionNode)c).getCondition()), false);
        return conditionList;
    }

    public Collection<ConditionNode> collectSubTree(Predicate<? super ConditionNode> predicate, boolean brake) {
        ArrayList<ConditionNode> nodes = new ArrayList<ConditionNode>(this.size);
        this.iterTree(predicate, c -> nodes.add((ConditionNode)c), brake);
        return nodes;
    }

    public ConditionNode collectConditionTree() {
        return this.head;
    }

    public Conditions insulate() {
        if (this.head != null) {
            this.head.setClosed(true);
        }
        return this;
    }

    public String toString() {
        return this.head.toString();
    }

    public String toPrefixExpression() {
        return this.head.toPrefixExpression();
    }

    public int size() {
        return this.size;
    }

    public boolean isEmtpy() {
        return this.size == 0;
    }

    public static boolean isValueNode(ConditionNode node) {
        return node instanceof ValueConditionNode;
    }

    public static boolean isLinkNode(ConditionNode node) {
        return node instanceof LinkConditionNode;
    }

    private Conditions doAdd(ConditionLink link, Condition condition) {
        this.validate(condition);
        ValueConditionNode newValueNode = new ValueConditionNode(condition);
        this.doAddNode(newValueNode, link, false);
        ++this.size;
        if (link == ConditionLink.OR) {
            this.or = true;
        }
        if (!this.range) {
            this.range = condition.isRange();
        }
        return this;
    }

    private void validate(Condition condition) {
        ConditionValidation validation = ConditionOperatorFieldValidationFactory.getValidation(condition.getField().type());
        if (!validation.validate(condition)) {
            throw new IllegalArgumentException(String.format("Wrong conditions.[%s]", condition.toString()));
        }
    }

    private Conditions doAdd(ConditionLink link, Conditions conditions, boolean isolation) {
        this.doAddNode(conditions.head, link, isolation);
        if (ConditionLink.OR == link && this.size > 0) {
            this.or = true;
        } else if (!this.or) {
            this.or = conditions.haveOrLink();
        }
        if (!this.range) {
            this.range = conditions.haveRangeCondition();
        }
        this.size += conditions.size();
        return this;
    }

    private void doAddNode(ConditionNode newNode, ConditionLink link, boolean isolation) {
        if (this.size == 0) {
            this.head = newNode;
        } else {
            if (isolation && Conditions.isLinkNode(newNode)) {
                newNode.setClosed(true);
            }
            boolean onlyOneCondition = true;
            if (this.size == 1) {
                LinkConditionNode newLinkNode = new LinkConditionNode(this.head, newNode, link);
                if (ConditionLink.OR == link) {
                    newLinkNode.setRed(true);
                }
                this.head = newLinkNode;
            } else {
                LinkConditionNode linkHead = (LinkConditionNode)this.head;
                if (!linkHead.isClosed() && linkHead.getLink() == ConditionLink.OR && ConditionLink.AND == link) {
                    LinkConditionNode newLinkNode = new LinkConditionNode(linkHead.getRight(), newNode, ConditionLink.AND);
                    linkHead.setRight(newLinkNode);
                } else {
                    LinkConditionNode newLinkNode = new LinkConditionNode(this.head, newNode, link);
                    this.head = newLinkNode;
                }
            }
        }
    }

    private void iterTree(Predicate<? super ConditionNode> predicate, Consumer<? super ConditionNode> consumer, boolean brake) {
        if (this.head == null) {
            return;
        }
        ArrayDeque<ConditionNode> stack = new ArrayDeque<ConditionNode>(this.size());
        stack.push(this.head);
        while (!stack.isEmpty()) {
            ConditionNode node = (ConditionNode)stack.pop();
            if (predicate.test(node)) {
                consumer.accept(node);
                if (brake) continue;
            }
            if (node.getRight() != null) {
                stack.push(node.getRight());
            }
            if (node.getLeft() == null) continue;
            stack.push(node.getLeft());
        }
    }
}

