/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityFamily;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityFamily;
import java.io.Serializable;
import java.util.Objects;

public class Entity
implements IEntity,
Serializable {
    private static final IEntityFamily EMPTY_FAMILY = new EntityFamily(0L, 0L);
    private long id;
    private IEntityClass entityClass;
    private IEntityValue entityValue;
    private IEntityFamily family = EMPTY_FAMILY;
    private int version;

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public IEntityClass entityClass() {
        return this.entityClass;
    }

    @Override
    public IEntityValue entityValue() {
        return this.entityValue;
    }

    @Override
    public void resetEntityValue(IEntityValue iEntityValue) {
        this.entityValue = iEntityValue;
    }

    @Override
    public IEntityFamily family() {
        return this.family;
    }

    @Override
    public int version() {
        return this.version;
    }

    public Entity(long id, IEntityClass entityClass, IEntityValue entityValue) {
        this(id, entityClass, entityValue, null, 0);
    }

    public Entity(long id, IEntityClass entityClass, IEntityValue entityValue, int version) {
        this(id, entityClass, entityValue, null, version);
    }

    public Entity(long id, IEntityClass entityClass, IEntityValue entityValue, IEntityFamily family, int version) {
        if (entityClass == null) {
            throw new IllegalArgumentException("Invalid class meta information.");
        }
        if (entityValue == null) {
            throw new IllegalArgumentException("Invalid attribute value.");
        }
        this.id = id;
        this.entityClass = entityClass;
        this.entityValue = entityValue;
        if (family != null) {
            this.family = family;
        }
        this.version = version;
    }

    @Override
    public void resetId(long id) {
        this.id = id;
        this.entityValue.restId(id);
    }

    @Override
    public void resetFamily(IEntityFamily family) {
        this.family = family;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new Entity(this.id(), this.entityClass(), (IEntityValue)this.entityValue().clone(), this.family(), this.version());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Entity)) {
            return false;
        }
        Entity entity = (Entity)o;
        return this.id == entity.id && this.version == entity.version && Objects.equals(this.entityClass, entity.entityClass) && Objects.equals(this.entityValue, entity.entityValue) && Objects.equals(this.family, entity.family);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.entityClass, this.entityValue, this.family, this.version);
    }

    public String toString() {
        return "Entity{id=" + this.id + ", entityClass=" + this.entityClass + ", entityValue=" + this.entityValue + ", family=" + this.family + ", version=" + this.version + '}';
    }
}

