/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityValue;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class EntityValue
implements IEntityValue,
Cloneable,
Serializable {
    private long id;
    private Map<Long, IValue> values;

    public EntityValue(long id) {
        this.id = id;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public void restId(long id) {
        this.id = id;
    }

    @Override
    public Optional<IValue> getValue(String fieldName) {
        if (this.values == null) {
            return Optional.empty();
        }
        for (IValue v : this.values.values()) {
            if (!v.getField().name().equals(fieldName)) continue;
            return Optional.of(v);
        }
        return Optional.empty();
    }

    @Override
    public Optional<IValue> getValue(long fieldId) {
        return this.values.entrySet().stream().filter((? super T x) -> (Long)x.getKey() == fieldId).map(Map.Entry::getValue).findFirst();
    }

    @Override
    public IEntityValue addValue(IValue value) {
        this.lazyInit();
        this.values.put(value.getField().id(), value);
        return this;
    }

    @Override
    public Collection<IValue> values() {
        if (this.values == null) {
            return Collections.emptyList();
        }
        return this.values.values();
    }

    @Override
    public IEntityValue addValues(Collection<IValue> values) {
        this.lazyInit();
        values.stream().forEach(v -> this.values.put(v.getField().id(), (IValue)v));
        return this;
    }

    @Override
    public IValue remove(IEntityField field) {
        this.lazyInit();
        return this.values.remove(field.id());
    }

    @Override
    public void filter(Predicate<? super IValue> predicate) {
        this.values.entrySet().removeIf(entry -> !predicate.test((IValue)entry.getValue()));
    }

    @Override
    public IEntityValue clear() {
        if (this.values != null) {
            this.values.clear();
        }
        return this;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EntityValue cloneValue = new EntityValue(this.id);
        cloneValue.addValues(this.values());
        return cloneValue;
    }

    private void lazyInit() {
        if (this.values == null) {
            this.values = new LinkedHashMap<Long, IValue>();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityValue)) {
            return false;
        }
        EntityValue that = (EntityValue)o;
        return this.id == that.id && this.equalsValues(that);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.values);
    }

    public String toString() {
        return "EntityValue{id=" + this.id + ", values=" + (this.values != null ? this.values.toString() : "NULL") + '}';
    }

    private boolean equalsValues(EntityValue that) {
        Map<Long, IValue> thatValues = that.values;
        if (this.values == thatValues) {
            return true;
        }
        if (thatValues.size() != this.values.size()) {
            return false;
        }
        for (Long id : this.values.keySet()) {
            IValue thatValue;
            IValue thisValue = this.values.get(id);
            if (thisValue.equals(thatValue = thatValues.get(id))) continue;
            return false;
        }
        return true;
    }
}

