/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.grpc.GrpcProtocol;
import akka.grpc.Trailers;
import akka.grpc.javadsl.GrpcExceptionHandler;
import akka.grpc.javadsl.GrpcMarshalling;
import akka.grpc.javadsl.Metadata;
import akka.grpc.javadsl.MetadataBuilder;
import akka.http.javadsl.model.HttpRequest;
import akka.http.javadsl.model.HttpResponse;
import akka.http.javadsl.model.StatusCodes;
import akka.japi.Function;
import akka.stream.Materializer;
import akka.stream.SystemMaterializer;
import akka.stream.javadsl.Source;
import com.xforceplus.ultraman.oqsengine.sdk.EntityRebuildService;
import com.xforceplus.ultraman.oqsengine.sdk.EntityRebuildServicePowerApi;
import com.xforceplus.ultraman.oqsengine.sdk.EntityUp;
import com.xforceplus.ultraman.oqsengine.sdk.EntityUpList;
import com.xforceplus.ultraman.oqsengine.sdk.QueryPage;
import com.xforceplus.ultraman.oqsengine.sdk.RebuildRequest;
import com.xforceplus.ultraman.oqsengine.sdk.RepairRequest;
import com.xforceplus.ultraman.oqsengine.sdk.ShowTask;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class EntityRebuildServicePowerApiHandlerFactory {
    private static final CompletionStage<HttpResponse> notFound = CompletableFuture.completedFuture(HttpResponse.create().withStatus(StatusCodes.NOT_FOUND));
    private static final CompletionStage<HttpResponse> unsupportedMediaType = CompletableFuture.completedFuture(HttpResponse.create().withStatus(StatusCodes.UNSUPPORTED_MEDIA_TYPE));

    public static Function<HttpRequest, CompletionStage<HttpResponse>> create(EntityRebuildServicePowerApi implementation, ClassicActorSystemProvider system) {
        return EntityRebuildServicePowerApiHandlerFactory.create(implementation, "EntityRebuildService", system);
    }

    public static Function<HttpRequest, CompletionStage<HttpResponse>> create(EntityRebuildServicePowerApi implementation, Function<ActorSystem, Function<Throwable, Trailers>> eHandler, ClassicActorSystemProvider system) {
        return EntityRebuildServicePowerApiHandlerFactory.create(implementation, "EntityRebuildService", eHandler, system);
    }

    public static Function<HttpRequest, CompletionStage<HttpResponse>> create(EntityRebuildServicePowerApi implementation, String prefix, ClassicActorSystemProvider system) {
        return EntityRebuildServicePowerApiHandlerFactory.partial(implementation, prefix, SystemMaterializer.get((ClassicActorSystemProvider)system).materializer(), (Function<ActorSystem, Function<Throwable, Trailers>>)GrpcExceptionHandler.defaultMapper(), system);
    }

    public static Function<HttpRequest, CompletionStage<HttpResponse>> create(EntityRebuildServicePowerApi implementation, String prefix, Function<ActorSystem, Function<Throwable, Trailers>> eHandler, ClassicActorSystemProvider system) {
        return EntityRebuildServicePowerApiHandlerFactory.partial(implementation, prefix, SystemMaterializer.get((ClassicActorSystemProvider)system).materializer(), eHandler, system);
    }

    public static Function<HttpRequest, CompletionStage<HttpResponse>> partial(EntityRebuildServicePowerApi implementation, String prefix, ClassicActorSystemProvider system) {
        return EntityRebuildServicePowerApiHandlerFactory.partial(implementation, prefix, SystemMaterializer.get((ClassicActorSystemProvider)system).materializer(), (Function<ActorSystem, Function<Throwable, Trailers>>)GrpcExceptionHandler.defaultMapper(), system);
    }

    public static Function<HttpRequest, CompletionStage<HttpResponse>> partial(EntityRebuildServicePowerApi implementation, String prefix, Materializer mat, Function<ActorSystem, Function<Throwable, Trailers>> eHandler, ClassicActorSystemProvider system) {
        return req -> {
            Iterator segments = req.getUri().pathSegments().iterator();
            if (segments.hasNext() && ((String)segments.next()).equals(prefix) && segments.hasNext()) {
                String method = (String)segments.next();
                if (segments.hasNext()) {
                    return notFound;
                }
                return EntityRebuildServicePowerApiHandlerFactory.handle(req, method, implementation, mat, eHandler, system);
            }
            return notFound;
        };
    }

    public String getServiceName() {
        return "EntityRebuildService";
    }

    private static CompletionStage<HttpResponse> handle(HttpRequest request, String method, EntityRebuildServicePowerApi implementation, Materializer mat, Function<ActorSystem, Function<Throwable, Trailers>> eHandler, ClassicActorSystemProvider system) {
        return GrpcMarshalling.negotiated((HttpRequest)request, (reader, writer) -> {
            CompletionStage<HttpResponse> response;
            Metadata metadata = MetadataBuilder.fromHeaders((Iterable)request.getHeaders());
            switch (method) {
                case "rebuildIndex": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityRebuildService.Serializers.RebuildRequestSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenCompose(e -> implementation.rebuildIndex((RebuildRequest)e, metadata)).thenApply(e -> GrpcMarshalling.marshal((Object)e, EntityRebuildService.Serializers.RebuildTaskInfoSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "showProgress": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityRebuildService.Serializers.ShowTaskSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenApply(e -> implementation.showProgress((ShowTask)e, metadata)).thenApply(e -> GrpcMarshalling.marshalStream((Source)e, EntityRebuildService.Serializers.RebuildTaskInfoSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "listActiveTasks": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityRebuildService.Serializers.QueryPageSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenApply(e -> implementation.listActiveTasks((QueryPage)e, metadata)).thenApply(e -> GrpcMarshalling.marshalStream((Source)e, EntityRebuildService.Serializers.RebuildTaskInfoSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "getActiveTask": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityRebuildService.Serializers.EntityUpSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenCompose(e -> implementation.getActiveTask((EntityUp)e, metadata)).thenApply(e -> GrpcMarshalling.marshal((Object)e, EntityRebuildService.Serializers.RebuildTaskInfoSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "listAllTasks": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityRebuildService.Serializers.QueryPageSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenApply(e -> implementation.listAllTasks((QueryPage)e, metadata)).thenApply(e -> GrpcMarshalling.marshalStream((Source)e, EntityRebuildService.Serializers.RebuildTaskInfoSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "cancelTask": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityRebuildService.Serializers.ShowTaskSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenCompose(e -> implementation.cancelTask((ShowTask)e, metadata)).thenApply(e -> GrpcMarshalling.marshal((Object)e, EntityRebuildService.Serializers.RebuildTaskInfoSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "entityRepair": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityRebuildService.Serializers.EntityUpListSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenCompose(e -> implementation.entityRepair((EntityUpList)e, metadata)).thenApply(e -> GrpcMarshalling.marshal((Object)e, EntityRebuildService.Serializers.OperationResultSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "cancelEntityRepair": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityRebuildService.Serializers.RepairRequestSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenCompose(e -> implementation.cancelEntityRepair((RepairRequest)e, metadata)).thenApply(e -> GrpcMarshalling.marshal((Object)e, EntityRebuildService.Serializers.OperationResultSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "clearRepairedInfos": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityRebuildService.Serializers.RepairRequestSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenCompose(e -> implementation.clearRepairedInfos((RepairRequest)e, metadata)).thenApply(e -> GrpcMarshalling.marshal((Object)e, EntityRebuildService.Serializers.OperationResultSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "repairedInfoList": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityRebuildService.Serializers.RepairRequestSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenApply(e -> implementation.repairedInfoList((RepairRequest)e, metadata)).thenApply(e -> GrpcMarshalling.marshalStream((Source)e, EntityRebuildService.Serializers.RebuildTaskInfoSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "isEntityRepaired": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityRebuildService.Serializers.RepairRequestSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenCompose(e -> implementation.isEntityRepaired((RepairRequest)e, metadata)).thenApply(e -> GrpcMarshalling.marshal((Object)e, EntityRebuildService.Serializers.OperationResultSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "removeCommitIds": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityRebuildService.Serializers.RepairRequestSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenCompose(e -> implementation.removeCommitIds((RepairRequest)e, metadata)).thenApply(e -> GrpcMarshalling.marshal((Object)e, EntityRebuildService.Serializers.OperationResultSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "initNewCommitId": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityRebuildService.Serializers.RepairRequestSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenCompose(e -> implementation.initNewCommitId((RepairRequest)e, metadata)).thenApply(e -> GrpcMarshalling.marshal((Object)e, EntityRebuildService.Serializers.OperationResultSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                default: {
                    CompletableFuture<HttpResponse> result = new CompletableFuture<HttpResponse>();
                    result.completeExceptionally(new UnsupportedOperationException("Not implemented: " + method));
                    response = result;
                }
            }
            return response.exceptionally(e -> GrpcExceptionHandler.standard((Throwable)e, (Function)eHandler, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system));
        }).orElseGet(() -> unsupportedMediaType);
    }
}

