/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.grpc.GrpcProtocol;
import akka.grpc.Trailers;
import akka.grpc.javadsl.GrpcExceptionHandler;
import akka.grpc.javadsl.GrpcMarshalling;
import akka.http.javadsl.model.HttpRequest;
import akka.http.javadsl.model.HttpResponse;
import akka.http.javadsl.model.StatusCodes;
import akka.japi.Function;
import akka.stream.Materializer;
import akka.stream.SystemMaterializer;
import akka.stream.javadsl.Source;
import com.xforceplus.ultraman.oqsengine.sdk.EntityService;
import com.xforceplus.ultraman.oqsengine.sdk.EntityUp;
import com.xforceplus.ultraman.oqsengine.sdk.SelectByCondition;
import com.xforceplus.ultraman.oqsengine.sdk.TransactionUp;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class EntityServiceHandlerFactory {
    private static final CompletionStage<HttpResponse> notFound = CompletableFuture.completedFuture(HttpResponse.create().withStatus(StatusCodes.NOT_FOUND));
    private static final CompletionStage<HttpResponse> unsupportedMediaType = CompletableFuture.completedFuture(HttpResponse.create().withStatus(StatusCodes.UNSUPPORTED_MEDIA_TYPE));

    public static Function<HttpRequest, CompletionStage<HttpResponse>> create(EntityService implementation, ClassicActorSystemProvider system) {
        return EntityServiceHandlerFactory.create(implementation, "EntityService", system);
    }

    public static Function<HttpRequest, CompletionStage<HttpResponse>> create(EntityService implementation, Function<ActorSystem, Function<Throwable, Trailers>> eHandler, ClassicActorSystemProvider system) {
        return EntityServiceHandlerFactory.create(implementation, "EntityService", eHandler, system);
    }

    public static Function<HttpRequest, CompletionStage<HttpResponse>> create(EntityService implementation, String prefix, ClassicActorSystemProvider system) {
        return EntityServiceHandlerFactory.partial(implementation, prefix, SystemMaterializer.get((ClassicActorSystemProvider)system).materializer(), (Function<ActorSystem, Function<Throwable, Trailers>>)GrpcExceptionHandler.defaultMapper(), system);
    }

    public static Function<HttpRequest, CompletionStage<HttpResponse>> create(EntityService implementation, String prefix, Function<ActorSystem, Function<Throwable, Trailers>> eHandler, ClassicActorSystemProvider system) {
        return EntityServiceHandlerFactory.partial(implementation, prefix, SystemMaterializer.get((ClassicActorSystemProvider)system).materializer(), eHandler, system);
    }

    public static Function<HttpRequest, CompletionStage<HttpResponse>> partial(EntityService implementation, String prefix, ClassicActorSystemProvider system) {
        return EntityServiceHandlerFactory.partial(implementation, prefix, SystemMaterializer.get((ClassicActorSystemProvider)system).materializer(), (Function<ActorSystem, Function<Throwable, Trailers>>)GrpcExceptionHandler.defaultMapper(), system);
    }

    public static Function<HttpRequest, CompletionStage<HttpResponse>> partial(EntityService implementation, String prefix, Materializer mat, Function<ActorSystem, Function<Throwable, Trailers>> eHandler, ClassicActorSystemProvider system) {
        return req -> {
            Iterator segments = req.getUri().pathSegments().iterator();
            if (segments.hasNext() && ((String)segments.next()).equals(prefix) && segments.hasNext()) {
                String method = (String)segments.next();
                if (segments.hasNext()) {
                    return notFound;
                }
                return EntityServiceHandlerFactory.handle(req, method, implementation, mat, eHandler, system);
            }
            return notFound;
        };
    }

    public String getServiceName() {
        return "EntityService";
    }

    private static CompletionStage<HttpResponse> handle(HttpRequest request, String method, EntityService implementation, Materializer mat, Function<ActorSystem, Function<Throwable, Trailers>> eHandler, ClassicActorSystemProvider system) {
        return GrpcMarshalling.negotiated((HttpRequest)request, (reader, writer) -> {
            CompletionStage<HttpResponse> response;
            switch (method) {
                case "begin": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityService.Serializers.TransactionUpSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenCompose(e -> implementation.begin((TransactionUp)e)).thenApply(e -> GrpcMarshalling.marshal((Object)e, EntityService.Serializers.OperationResultSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "build": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityService.Serializers.EntityUpSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenCompose(e -> implementation.build((EntityUp)e)).thenApply(e -> GrpcMarshalling.marshal((Object)e, EntityService.Serializers.OperationResultSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "replace": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityService.Serializers.EntityUpSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenCompose(e -> implementation.replace((EntityUp)e)).thenApply(e -> GrpcMarshalling.marshal((Object)e, EntityService.Serializers.OperationResultSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "replaceByCondition": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityService.Serializers.SelectByConditionSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenCompose(e -> implementation.replaceByCondition((SelectByCondition)e)).thenApply(e -> GrpcMarshalling.marshal((Object)e, EntityService.Serializers.OperationResultSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "remove": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityService.Serializers.EntityUpSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenCompose(e -> implementation.remove((EntityUp)e)).thenApply(e -> GrpcMarshalling.marshal((Object)e, EntityService.Serializers.OperationResultSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "selectOne": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityService.Serializers.EntityUpSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenCompose(e -> implementation.selectOne((EntityUp)e)).thenApply(e -> GrpcMarshalling.marshal((Object)e, EntityService.Serializers.OperationResultSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "selectByConditions": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityService.Serializers.SelectByConditionSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenCompose(e -> implementation.selectByConditions((SelectByCondition)e)).thenApply(e -> GrpcMarshalling.marshal((Object)e, EntityService.Serializers.OperationResultSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "commit": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityService.Serializers.TransactionUpSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenCompose(e -> implementation.commit((TransactionUp)e)).thenApply(e -> GrpcMarshalling.marshal((Object)e, EntityService.Serializers.OperationResultSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                case "rollBack": {
                    response = GrpcMarshalling.unmarshal((Source)request.entity().getDataBytes(), EntityService.Serializers.TransactionUpSerializer, (Materializer)mat, (GrpcProtocol.GrpcProtocolReader)reader).thenCompose(e -> implementation.rollBack((TransactionUp)e)).thenApply(e -> GrpcMarshalling.marshal((Object)e, EntityService.Serializers.OperationResultSerializer, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system, (Function)eHandler));
                    break;
                }
                default: {
                    CompletableFuture<HttpResponse> result = new CompletableFuture<HttpResponse>();
                    result.completeExceptionally(new UnsupportedOperationException("Not implemented: " + method));
                    response = result;
                }
            }
            return response.exceptionally(e -> GrpcExceptionHandler.standard((Throwable)e, (Function)eHandler, (GrpcProtocol.GrpcProtocolWriter)writer, (ClassicActorSystemProvider)system));
        }).orElseGet(() -> unsupportedMediaType);
    }
}

